/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.cloud.client.JiraCloudDevInfoClient;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntity;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoEntityVisitor;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInformation;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch.BranchModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.PullRequestModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository.RepositoryModel;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.service.EscalatedJiraSiteConfigSupplier;
import com.atlassian.stash.internal.jira.cloud.sync.DeleteEntityRequest;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoConfig;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoSender;
import com.atlassian.stash.internal.jira.cloud.sync.ModelConverter;
import com.atlassian.stash.internal.jira.cloud.util.EntityIdConverter;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.List;

public class DefaultDevInfoSender
implements DevInfoSender {
    private final DevInfoConfig devInfoConfig;
    private final EntityIdConverter entityIdConverter;
    private final JiraCloudDevInfoClient jiraCloudDevInfoClient;
    private final EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier;
    private final ModelConverter modelConverter;

    public DefaultDevInfoSender(DevInfoConfig devInfoConfig, EntityIdConverter entityIdConverter, JiraCloudDevInfoClient jiraCloudDevInfoClient, EscalatedJiraSiteConfigSupplier jiraSiteConfigSupplier, ModelConverter modelConverter) {
        this.devInfoConfig = devInfoConfig;
        this.entityIdConverter = entityIdConverter;
        this.jiraCloudDevInfoClient = jiraCloudDevInfoClient;
        this.jiraSiteConfigSupplier = jiraSiteConfigSupplier;
        this.modelConverter = modelConverter;
    }

    @Override
    public void delete(@Nonnull Collection<DeleteEntityRequest> deleteRequests) {
        for (DeleteEntityRequest deleteRequest : deleteRequests) {
            String cloudRepoId = this.entityIdConverter.convertToCloudEntityId(DevInfoType.REPOSITORY, Integer.toString(deleteRequest.getRepository().getId()));
            for (JiraSiteConfig siteConfig : this.jiraSiteConfigSupplier.getAll()) {
                this.jiraCloudDevInfoClient.deleteDevInfo(siteConfig, cloudRepoId, deleteRequest.getType(), this.entityIdConverter.convertToCloudEntityId(deleteRequest.getType(), deleteRequest.getEntityId()));
            }
        }
    }

    @Override
    public void send(@Nonnull Repository repository, @Nonnull Collection<? extends DevInfoEntity> entities) {
        if (entities.isEmpty()) {
            return;
        }
        List<JiraSiteConfig> sites = this.jiraSiteConfigSupplier.getAll();
        if (sites.isEmpty()) {
            return;
        }
        Iterable partitions = Iterables.partition(entities, (int)this.devInfoConfig.getMaxEntitiesPerRepository());
        for (List partition : partitions) {
            this.sendPartitionedEntities(sites, repository, partition);
        }
    }

    private void sendPartitionedEntities(List<JiraSiteConfig> sites, Repository repository, List<? extends DevInfoEntity> entities) {
        RepositoryModel.Builder repoModelBuilder = this.modelConverter.toRepositoryModelBuilder(repository);
        RepositoryModelPopulatingVisitor repositoryModelPopulatingVisitor = new RepositoryModelPopulatingVisitor(repoModelBuilder);
        for (DevInfoEntity devInfoEntity : entities) {
            devInfoEntity.accept(repositoryModelPopulatingVisitor);
        }
        DevInformation devInformation = this.modelConverter.toDevInformation(repoModelBuilder.build(), repository);
        for (JiraSiteConfig siteConfig : sites) {
            this.jiraCloudDevInfoClient.sendDevInfo(siteConfig, devInformation);
        }
    }

    private static class RepositoryModelPopulatingVisitor
    implements DevInfoEntityVisitor {
        private final RepositoryModel.Builder repoModelBuilder;

        private RepositoryModelPopulatingVisitor(RepositoryModel.Builder repoModelBuilder) {
            this.repoModelBuilder = repoModelBuilder;
        }

        @Override
        public void visit(BranchModel branch) {
            this.repoModelBuilder.branch(branch);
        }

        @Override
        public void visit(CommitModel commit) {
            this.repoModelBuilder.commit(commit);
        }

        @Override
        public void visit(PullRequestModel pullRequest) {
            this.repoModelBuilder.pullRequest(pullRequest);
        }
    }
}

