/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.google.common.base.Preconditions;
import java.util.Objects;

public final class DeleteEntityRequest {
    private final String entityId;
    private final Repository repository;
    private final DevInfoType type;

    public DeleteEntityRequest(Repository repository, DevInfoType type, String entityId) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.type = Objects.requireNonNull(type, "type");
        Preconditions.checkArgument((boolean)type.getEntityTypeForDeletion().isPresent(), (Object)("This request is not applicable for type " + String.valueOf((Object)type)));
        this.entityId = Objects.requireNonNull(entityId, "entityId");
    }

    public String getEntityId() {
        return this.entityId;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public DevInfoType getType() {
        return this.type;
    }
}

