/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.dmz.deployments.DeploymentEnvironmentType;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DeploymentEnvironmentMapper {
    static final String DEVELOPMENT_KEYWORDS_DEFAULT = "dev,review,development,trunk";
    static final String PRODUCTION_KEYWORDS_DEFAULT = "prod,production,prd,live";
    static final String STAGING_KEYWORDS_DEFAULT = "staging,stage,stg,preprod,pre-prod,model,internal";
    static final String TEST_KEYWORDS_DEFAULT = "test,testing,tests,tst,integration,integ,intg,int,acceptance,accept,acpt,qa,qc,control,quality";
    private static final String KEYWORD_PREFIX = "plugin.jira-development-integration.deployment-environment-type.keywords.";
    static final String DEVELOPMENT_KEYWORDS = "plugin.jira-development-integration.deployment-environment-type.keywords.dev";
    static final String PRODUCTION_KEYWORDS = "plugin.jira-development-integration.deployment-environment-type.keywords.prod";
    static final String STAGING_KEYWORDS = "plugin.jira-development-integration.deployment-environment-type.keywords.staging";
    static final String TEST_KEYWORDS = "plugin.jira-development-integration.deployment-environment-type.keywords.test";
    private final Pattern devPattern;
    private final Pattern prodPattern;
    private final Pattern stgPattern;
    private final Pattern testPattern;

    public DeploymentEnvironmentMapper(ApplicationPropertiesService propertiesService) {
        this.devPattern = DeploymentEnvironmentMapper.convertToRegexPattern(propertiesService.getPluginProperty(DEVELOPMENT_KEYWORDS, DEVELOPMENT_KEYWORDS_DEFAULT));
        this.prodPattern = DeploymentEnvironmentMapper.convertToRegexPattern(propertiesService.getPluginProperty(PRODUCTION_KEYWORDS, PRODUCTION_KEYWORDS_DEFAULT));
        this.stgPattern = DeploymentEnvironmentMapper.convertToRegexPattern(propertiesService.getPluginProperty(STAGING_KEYWORDS, STAGING_KEYWORDS_DEFAULT));
        this.testPattern = DeploymentEnvironmentMapper.convertToRegexPattern(propertiesService.getPluginProperty(TEST_KEYWORDS, TEST_KEYWORDS_DEFAULT));
    }

    public DeploymentEnvironmentType mapEnvironmentType(String environmentName) {
        if (this.devPattern != null && this.devPattern.matcher(environmentName).matches()) {
            return DeploymentEnvironmentType.DEVELOPMENT;
        }
        if (this.testPattern != null && this.testPattern.matcher(environmentName).matches()) {
            return DeploymentEnvironmentType.TESTING;
        }
        if (this.stgPattern != null && this.stgPattern.matcher(environmentName).matches()) {
            return DeploymentEnvironmentType.STAGING;
        }
        if (this.prodPattern != null && this.prodPattern.matcher(environmentName).matches()) {
            return DeploymentEnvironmentType.PRODUCTION;
        }
        return null;
    }

    private static Pattern convertToRegexPattern(String keywords) {
        if (StringUtils.isBlank((CharSequence)keywords)) {
            return null;
        }
        String escapedKeywords = Arrays.stream(keywords.split(",")).map(word -> Pattern.quote(word.trim())).collect(Collectors.joining("|"));
        return Pattern.compile(String.format("(?i)^.*\\b(%s)\\b.*$", escapedKeywords));
    }
}

