/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;

public class DevInfoConfig {
    private static final String MAX_BRANCHES_PER_EVENT_PROP = "plugin.jira-development-integration.cloud.devinfo.event.branch.max";
    private static final int MAX_BRANCHES_PER_EVENT_DEFAULT = 100;
    private static final String MAX_COMMITS_PER_EVENT_PROP = "plugin.jira-development-integration.cloud.devinfo.event.commit.max";
    private static final int MAX_COMMITS_PER_EVENT_DEFAULT = 200;
    private static final String MAX_ENTITIES_PER_REPOSITORY_PROP = "plugin.jira-development-integration.cloud.devinfo.repository.entity.max";
    private static final int MAX_ENTITIES_PER_REPOSITORY_DEFAULT = 100;
    private static final String MAX_FILES_PER_COMMIT_PROP = "plugin.jira-development-integration.cloud.devinfo.commit.files.max";
    private static final int MAX_FILES_PER_COMMIT_DEFAULT = 10;
    private static final String MAX_ISSUE_KEYS_PER_ENTITY_PROP = "plugin.jira-development-integration.cloud.devinfo.entity.issuekeys.max";
    private static final int MAX_ISSUE_KEYS_PER_ENTITY_DEFAULT = 100;
    private final ApplicationPropertiesService propertiesService;

    public DevInfoConfig(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public int getMaxBranchesPerEvent() {
        return this.propertiesService.getPluginProperty(MAX_BRANCHES_PER_EVENT_PROP, 100);
    }

    public int getMaxCommitsPerEvent() {
        return this.propertiesService.getPluginProperty(MAX_COMMITS_PER_EVENT_PROP, 200);
    }

    public int getMaxEntitiesPerRepository() {
        return this.propertiesService.getPluginProperty(MAX_ENTITIES_PER_REPOSITORY_PROP, 100);
    }

    public int getMaxFilesPerCommit() {
        return this.propertiesService.getPluginProperty(MAX_FILES_PER_COMMIT_PROP, 10);
    }

    public int getMaxIssueKeysPerEntity() {
        return this.propertiesService.getPluginProperty(MAX_ISSUE_KEYS_PER_ENTITY_PROP, 100);
    }
}

