/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.httpclient.api.Response;
import com.atlassian.stash.internal.jira.cloud.client.model.ErrorMessage;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.error.ErrorMessages;
import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfigConnectionUpdateRequest;
import com.atlassian.stash.internal.jira.http.client.exception.HttpClientException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class ErrorMessageHandler {
    @VisibleForTesting
    static final int MSG_LIMIT = 425;
    private final ObjectMapper objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public JiraSiteConfigConnectionUpdateRequest createConnectionUpdateRequest(int jiraSiteId, Throwable throwable) {
        ConnectionStatus connectionStatus = ErrorMessageHandler.determineErrorType(throwable);
        return JiraSiteConfigConnectionUpdateRequest.updateForFailure(jiraSiteId, connectionStatus, this.parseErrorMessage(throwable));
    }

    private String parseErrorMessage(Throwable throwable) {
        try {
            HttpClientException exception = (HttpClientException)throwable;
            Response response = exception.getErrorResponse();
            ErrorMessages errorMessages = (ErrorMessages)this.objectMapper.readValue(response.getEntityStream(), ErrorMessages.class);
            String combinedErrorMessage = ErrorMessageHandler.combineErrorMessages(errorMessages);
            return ErrorMessageHandler.truncateMessage(combinedErrorMessage);
        }
        catch (Exception e) {
            return ErrorMessageHandler.truncateMessage(throwable.getMessage());
        }
    }

    private static String combineErrorMessages(ErrorMessages errorMessages) {
        return errorMessages.errorMessages().stream().map(ErrorMessage::message).collect(Collectors.joining(","));
    }

    private static ConnectionStatus determineErrorType(Throwable throwable) {
        HttpClientException exception;
        if (ErrorMessageHandler.isNetworkError(throwable)) {
            return ConnectionStatus.NETWORK_ERROR;
        }
        if (throwable instanceof HttpClientException && ErrorMessageHandler.isOAuthError(exception = (HttpClientException)throwable)) {
            return ConnectionStatus.OAUTH_PROBLEM;
        }
        return ConnectionStatus.UNKNOWN;
    }

    private static boolean isNetworkError(Throwable throwable) {
        return throwable instanceof IOException || Throwables.getRootCause((Throwable)throwable) instanceof IOException;
    }

    private static boolean isOAuthError(Throwable throwable) {
        if (throwable instanceof HttpClientException) {
            HttpClientException exception = (HttpClientException)throwable;
            Response response = exception.getErrorResponse();
            switch (response.getStatusCode()) {
                case 401: 
                case 403: {
                    return true;
                }
            }
        }
        return false;
    }

    private static String truncateMessage(String message) {
        if (message.length() < 425) {
            return message;
        }
        return StringUtils.abbreviate((String)message, (int)425);
    }
}

