/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.sync;

import com.atlassian.bitbucket.build.status.RepositoryBuildStatus;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestParticipant;
import com.atlassian.bitbucket.pull.PullRequestParticipantStatus;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.NumberUtils;
import com.atlassian.stash.internal.jira.cloud.client.model.AssociationModel;
import com.atlassian.stash.internal.jira.cloud.client.model.AssociationType;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildCommitReferenceModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildRefReferenceModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildReferencesModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusModel;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.BuildStatusRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.buildstatus.TestInfoModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.DeploymentsRequest;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.EnvironmentModel;
import com.atlassian.stash.internal.jira.cloud.client.model.deployment.PipelineModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInformation;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.IsoDateFormatConverter;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch.BranchModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.Author;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitFileChangeType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.CommitModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.File;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.commit.Flag;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.PullRequestModel;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.pull.Reviewer;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.repository.RepositoryModel;
import com.atlassian.stash.internal.jira.cloud.sync.DeploymentConfig;
import com.atlassian.stash.internal.jira.cloud.sync.DeploymentEnvironmentMapper;
import com.atlassian.stash.internal.jira.cloud.sync.DevInfoConfig;
import com.atlassian.stash.internal.jira.cloud.util.EntityIdConverter;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ModelConverter {
    @VisibleForTesting
    static final String REPOSITORY_ID_KEY = "repoId";
    private final DeploymentConfig deploymentConfig;
    private final DeploymentEnvironmentMapper deploymentEnvironmentMapper;
    private final DevInfoConfig devInfoConfig;
    private final EntityIdConverter entityIdConverter;
    private final Map<String, String> providerMetadata;
    private final UrlFactory urlFactory;

    public ModelConverter(ApplicationPropertiesService applicationPropertiesService, DeploymentConfig deploymentConfig, DeploymentEnvironmentMapper deploymentEnvironmentMapper, DevInfoConfig devInfoConfig, EntityIdConverter entityIdConverter, UrlFactory urlFactory) {
        this.devInfoConfig = devInfoConfig;
        this.deploymentConfig = deploymentConfig;
        this.deploymentEnvironmentMapper = deploymentEnvironmentMapper;
        this.entityIdConverter = entityIdConverter;
        this.urlFactory = urlFactory;
        this.providerMetadata = ModelConverter.createProviderMetadata(applicationPropertiesService);
    }

    public static Map<String, String> getProperties(Repository repository) {
        return new ImmutableMap.Builder().put((Object)REPOSITORY_ID_KEY, (Object)String.valueOf(repository.getId())).build();
    }

    public BranchModel toBranchModel(Repository repository, RefChange refChange, Set<String> issueKeys, Commit tipCommit) {
        MinimalRef branch = refChange.getRef();
        String branchUrl = this.urlFactory.ref(repository, branch.getId());
        String createPullRequestUrl = this.urlFactory.createPullRequest(repository, branch.getId());
        CommitModel tipCommitModel = this.toCommitModelWithoutIssuesOrChanges(repository, tipCommit);
        String cloudBranchId = this.entityIdConverter.convertToCloudEntityId(DevInfoType.BRANCH, branch.getId());
        return new BranchModel.Builder().id(cloudBranchId).name(branch.getDisplayId()).issueKeys(this.limitDevInfoIssueKeys(issueKeys)).timestamp(IsoDateFormatConverter.fromDate(new Date())).updateSequenceId(System.currentTimeMillis()).lastCommit(tipCommitModel).url(branchUrl).createPullRequestUrl(createPullRequestUrl).build();
    }

    public BuildStatusModel toBuildStatusModel(RepositoryBuildStatus buildStatus, Set<String> issueKeys) {
        BuildCommitReferenceModel commit = new BuildCommitReferenceModel.Builder().id(buildStatus.getCommitId()).repositoryUri(this.urlFactory.repository(buildStatus.getRepository())).build();
        BuildRefReferenceModel ref = buildStatus.getRef().map(refName -> new BuildRefReferenceModel.Builder().name((String)refName).uri(this.urlFactory.ref(buildStatus.getRepository(), (String)refName)).build()).orElse(null);
        BuildReferencesModel reference = new BuildReferencesModel.Builder().commit(commit).ref(ref).build();
        TestInfoModel testInfo = buildStatus.getTestResults().map(testResults -> {
            long numberFailed = testResults.getFailed().orElse(0).intValue();
            long numberPassed = testResults.getSuccessful().orElse(0).intValue();
            long numberSkipped = testResults.getSkipped().orElse(0).intValue();
            long totalNumber = numberFailed + numberPassed + numberSkipped;
            return new TestInfoModel.Builder().numberFailed(numberFailed).numberPassed(numberPassed).numberSkipped(numberSkipped).totalNumber(totalNumber).build();
        }).orElse(null);
        long buildNumber = NumberUtils.toLong((String)buildStatus.getBuildNumber().orElse(null), (Long)buildStatus.getCreatedDate().getTime());
        String displayName = buildStatus.getName().orElseGet(() -> buildStatus.getKey() + "-" + buildNumber);
        return new BuildStatusModel.Builder().buildNumber(buildNumber).description(buildStatus.getDescription().orElse(null)).displayName(displayName).issueKeys(issueKeys).lastUpdated(IsoDateFormatConverter.fromDate(buildStatus.getUpdatedDate())).pipelineId(buildStatus.getKey()).reference(reference).state(buildStatus.getState()).testInfo(testInfo).updateSequenceNumber(buildStatus.getUpdatedDate().getTime()).url(buildStatus.getUrl()).build();
    }

    public BuildStatusRequest toBuildStatusRequest(BuildStatusModel buildStatus, Repository repository) {
        return ((BuildStatusRequest.Builder)((BuildStatusRequest.Builder)new BuildStatusRequest.Builder().buildStatus(buildStatus).properties(ModelConverter.getProperties(repository))).providerMetadata(this.providerMetadata)).build();
    }

    public CommitModel toCommitModel(Repository repository, Commit commit, Person author, Set<String> issueKeys, Stream<Change> changes) {
        List<File> fileChanges = ModelConverter.toFiles(changes, change -> this.urlFactory.fileAtCommit(commit, change.getPath()));
        CommitModel.Builder commitBuilder = CommitModel.builder().id(commit.getId()).displayId(commit.getDisplayId()).hash(commit.getId()).message(StringUtils.trimToEmpty((String)commit.getMessage())).timestamp(IsoDateFormatConverter.fromDate(commit.getAuthorTimestamp())).authorTimestamp(IsoDateFormatConverter.fromDate(commit.getAuthorTimestamp())).updateSequenceId(System.currentTimeMillis()).issueKeys(this.limitDevInfoIssueKeys(issueKeys)).url(this.urlFactory.commit(repository, commit.getId())).fileCount(fileChanges.size()).files(fileChanges).author(this.toAuthor(author));
        if (commit.getParents().size() > 1) {
            commitBuilder.flags((Set<Flag>)ImmutableSet.of((Object)((Object)Flag.MERGE_COMMIT)));
        }
        return commitBuilder.build();
    }

    public DeploymentModel toDeploymentModel(Deployment deployment, Set<String> issueKeys) {
        String deploymentUrl = deployment.getUrl().toASCIIString();
        AssociationModel issueKeyAssociation = new AssociationModel.Builder().associationType(AssociationType.ISSUE_KEYS).values(this.limitDeploymentAssociationValues(issueKeys)).build();
        EnvironmentModel environment = new EnvironmentModel.Builder().id(deployment.getEnvironment().getKey()).displayName(deployment.getEnvironment().getDisplayName()).type(deployment.getEnvironment().getType().orElse(this.deploymentEnvironmentMapper.mapEnvironmentType(deployment.getEnvironment().getDisplayName()))).build();
        PipelineModel pipeline = new PipelineModel.Builder().id(deployment.getKey() + "-" + deployment.getRepository().getId()).displayName(deployment.getDisplayName()).url(deploymentUrl).build();
        return new DeploymentModel.Builder().association(issueKeyAssociation).deploymentSequenceNumber(deployment.getDeploymentSequenceNumber()).description(deployment.getDescription()).displayName(deployment.getDisplayName()).environment(environment).lastUpdated(IsoDateFormatConverter.fromDate(deployment.getLastUpdated())).pipeline(pipeline).state(deployment.getState()).updateSequenceNumber(deployment.getLastUpdated().getTime()).url(deploymentUrl).build();
    }

    public DeploymentsRequest toDeploymentsRequest(DeploymentModel deployment, Repository repository) {
        return ((DeploymentsRequest.Builder)((DeploymentsRequest.Builder)new DeploymentsRequest.Builder().deployment(deployment).properties(ModelConverter.getProperties(repository))).providerMetadata(this.providerMetadata)).build();
    }

    public DevInformation toDevInformation(RepositoryModel repositoryModel, Repository repository) {
        return ((DevInformation.Builder)((DevInformation.Builder)new DevInformation.Builder().repository(repositoryModel).properties(ModelConverter.getProperties(repository))).providerMetadata(this.providerMetadata)).build();
    }

    public PullRequestModel toPullRequestModel(Repository repository, PullRequest pullRequest, Set<String> issueKeys) {
        return new PullRequestModel.Builder().id(String.valueOf(pullRequest.getId())).author(this.toAuthor((Person)pullRequest.getAuthor().getUser())).destinationBranch(pullRequest.getToRef().getId()).displayId(String.valueOf(pullRequest.getId())).commentCount(0).issueKeys(this.limitDevInfoIssueKeys(issueKeys)).lastUpdate(IsoDateFormatConverter.fromDate(pullRequest.getUpdatedDate())).reviewers(pullRequest.getReviewers().stream().map(this::toReviewer).collect(Collectors.toSet())).sourceBranch(pullRequest.getFromRef().getId()).sourceBranchUrl(this.urlFactory.ref(repository, pullRequest.getFromRef().getId())).status(pullRequest.getState()).title(pullRequest.getTitle()).updateSequenceId(System.currentTimeMillis()).url(this.urlFactory.pullRequest(pullRequest)).build();
    }

    public RepositoryModel.Builder toRepositoryModelBuilder(Repository repository) {
        return new RepositoryModel.Builder().updateSequenceId(System.currentTimeMillis()).description(repository.getDescription()).name(repository.getName()).id(this.entityIdConverter.convertToCloudEntityId(DevInfoType.REPOSITORY, Integer.toString(repository.getId()))).avatar(this.urlFactory.projectAvatar(repository.getProject())).forkOf(this.fetchForkOfRepositoryId(repository)).url(this.urlFactory.repository(repository));
    }

    private static Map<String, String> createProviderMetadata(ApplicationPropertiesService service) {
        return ImmutableMap.of((Object)"product", (Object)"Bitbucket Server", (Object)"version", (Object)service.getBuildVersion(), (Object)"gitHash", (Object)service.getCommitHash());
    }

    private static List<File> toFiles(Stream<Change> changes, Function<Change, String> toFileUrl) {
        return changes == null ? Collections.emptyList() : (List)changes.map(change -> new File(change.getPath().toString(), (String)toFileUrl.apply((Change)change), CommitFileChangeType.fromChangeType(change.getType()), 0, 0)).collect(MoreCollectors.toImmutableList());
    }

    private String fetchForkOfRepositoryId(Repository repo) {
        return repo.isFork() && repo.getOrigin() != null ? this.entityIdConverter.convertToCloudEntityId(DevInfoType.REPOSITORY, Integer.toString(repo.getId())) : null;
    }

    private Set<String> limitDeploymentAssociationValues(@Nonnull Set<String> values) {
        if (values.size() > this.deploymentConfig.getMaxValuesPerAssociation()) {
            return values.stream().limit(this.deploymentConfig.getMaxValuesPerAssociation()).collect(Collectors.toSet());
        }
        return values;
    }

    private Set<String> limitDevInfoIssueKeys(@Nonnull Set<String> issueKeys) {
        if (issueKeys.size() > this.devInfoConfig.getMaxIssueKeysPerEntity()) {
            return issueKeys.stream().limit(this.devInfoConfig.getMaxIssueKeysPerEntity()).collect(Collectors.toSet());
        }
        return issueKeys;
    }

    private Author toAuthor(Person author) {
        Author.Builder authorBuilder = (Author.Builder)((Author.Builder)((Author.Builder)new Author.Builder().name(author.getName())).email(author.getEmailAddress())).avatar(this.urlFactory.userAvatar(author));
        if (author instanceof ApplicationUser) {
            ApplicationUser authorUser = (ApplicationUser)author;
            ((Author.Builder)authorBuilder.url(this.urlFactory.user(authorUser))).username(authorUser.getDisplayName());
        }
        return authorBuilder.build();
    }

    private CommitModel toCommitModelWithoutIssuesOrChanges(Repository repository, Commit commit) {
        return this.toCommitModel(repository, commit, commit.getAuthor(), Collections.emptySet(), Stream.empty());
    }

    private Reviewer toReviewer(PullRequestParticipant pullRequestParticipant) {
        ApplicationUser user = pullRequestParticipant.getUser();
        return ((Reviewer.Builder)((Reviewer.Builder)((Reviewer.Builder)((Reviewer.Builder)new Reviewer.Builder().name(user.getName())).approvalStatus(pullRequestParticipant.getStatus() == PullRequestParticipantStatus.NEEDS_WORK ? PullRequestParticipantStatus.UNAPPROVED : pullRequestParticipant.getStatus()).avatar(this.urlFactory.userAvatar((Person)user))).email(user.getEmailAddress())).url(this.urlFactory.user(user))).build();
    }
}

