/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.cloud.util;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.DevInfoType;
import com.atlassian.stash.internal.jira.cloud.client.model.devinfo.branch.BranchModel;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;

public class EntityIdConverter {
    private final ApplicationPropertiesService propertiesService;

    public EntityIdConverter(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    public String convertToCloudEntityId(DevInfoType type, String bitbucketId) {
        switch (type) {
            case BRANCH: {
                return BranchModel.convertBranchNameToJiraId(bitbucketId);
            }
            case COMMIT: {
                return bitbucketId;
            }
            case PULL_REQUEST: {
                return bitbucketId;
            }
            case REPOSITORY: {
                return this.createRepoEntityId(bitbucketId);
            }
        }
        throw new IllegalArgumentException("Unknown DevInfoType: " + String.valueOf((Object)type));
    }

    private String createRepoEntityId(String bitbucketId) {
        MessageDigest digest = DigestUtils.getSha256Digest();
        String compositeRepoId = bitbucketId + "-" + this.propertiesService.getServerId();
        digest.update(compositeRepoId.getBytes(StandardCharsets.UTF_8));
        return Hex.encodeHexString((byte[])digest.digest());
    }
}

