/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.deployment.event;

import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentDeletedEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentIndexingCompleteEvent;
import com.atlassian.bitbucket.dmz.deployments.event.DeploymentUpdatedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.jira.change.DeploymentChange;
import com.atlassian.stash.internal.jira.change.DeploymentChangeType;
import com.atlassian.stash.internal.jira.index.JiraDeploymentIndexService;
import com.atlassian.stash.internal.jira.listener.DeploymentChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

public class DeploymentEventListener {
    private final DeploymentChangeListener deploymentChangeListener;
    private final JiraDeploymentIndexService jiraDeploymentIndexService;

    public DeploymentEventListener(DeploymentChangeListener deploymentChangeListener, JiraDeploymentIndexService jiraDeploymentIndexService) {
        this.jiraDeploymentIndexService = jiraDeploymentIndexService;
        this.deploymentChangeListener = deploymentChangeListener;
    }

    @EventListener
    public void onDeploymentDeleted(@Nonnull DeploymentDeletedEvent event) {
        this.notifyDeploymentChangeListener((DeploymentEvent)event, DeploymentChangeType.DELETED);
        this.jiraDeploymentIndexService.deleteByDeploymentId(event.getDeployment().getId());
    }

    @EventListener
    public void onDeploymentIndexingComplete(@Nonnull DeploymentIndexingCompleteEvent event) {
        this.notifyDeploymentChangeListener((DeploymentEvent)event, DeploymentChangeType.INDEXED);
    }

    @EventListener
    public void onDeploymentUpdated(@Nonnull DeploymentUpdatedEvent event) {
        this.notifyDeploymentChangeListener((DeploymentEvent)event, DeploymentChangeType.UPDATED);
    }

    private void notifyDeploymentChangeListener(@Nonnull DeploymentEvent event, @Nonnull DeploymentChangeType deploymentChangeType) {
        Objects.requireNonNull(event, "event");
        Objects.requireNonNull(deploymentChangeType, "deploymentChangeType");
        Deployment deployment = event.getDeployment();
        Set<String> jiraIssueKeys = this.jiraDeploymentIndexService.findIssueKeys(deployment.getId());
        DeploymentChange deploymentChange = new DeploymentChange(deployment, jiraIssueKeys, deploymentChangeType);
        this.deploymentChangeListener.onDeploymentEvent(deploymentChange);
    }
}

