/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.http.client;

import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.factory.HttpClientFactory;
import com.atlassian.httpclient.api.factory.HttpClientOptions;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.stash.internal.jira.http.client.HttpClientConfiguration;
import com.atlassian.stash.internal.jira.http.client.HttpClientProvider;
import com.atlassian.stash.internal.jira.http.client.exception.HttpClientModuleNotInitializedException;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientProvider
implements HttpClientProvider,
LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpClientProvider.class);
    private final HttpClientConfiguration configuration;
    private final HttpClientFactory httpClientFactory;
    private volatile HttpClient httpClient;

    public DefaultHttpClientProvider(HttpClientFactory httpClientFactory, HttpClientConfiguration configuration) {
        this.httpClientFactory = httpClientFactory;
        this.configuration = configuration;
    }

    @Override
    @Nonnull
    public HttpClient getHttpClient() {
        HttpClient httpClient = this.httpClient;
        if (httpClient == null) {
            throw new HttpClientModuleNotInitializedException("The plugin hasn't been initialized yet. Dev info events will not be dispatched.");
        }
        return httpClient;
    }

    public void onStart() {
        HttpClientOptions options = new HttpClientOptions();
        options.setSocketTimeout(DefaultHttpClientProvider.toSeconds(this.configuration.getSocketTimeout()), TimeUnit.SECONDS);
        options.setConnectionTimeout(DefaultHttpClientProvider.toSeconds(this.configuration.getConnectionTimeout()), TimeUnit.SECONDS);
        options.setMaxCallbackThreadPoolSize(this.configuration.getMaxCallbackThreads());
        options.setMaxConnectionsPerHost(this.configuration.getMaxHttpConnectionsPerHost());
        options.setMaxTotalConnections(this.configuration.getMaxHttpConnections());
        this.httpClient = this.httpClientFactory.create(options);
    }

    public void onStop() {
        try {
            this.httpClientFactory.dispose(this.httpClient);
        }
        catch (Exception e) {
            log.warn("Failed to dispose a HttpClient on plugin shutdown");
            log.debug("Exception while doing a dispose on plugin shutdown.", (Throwable)e);
        }
    }

    private static int toSeconds(Duration duration) {
        return Ints.saturatedCast((long)duration.getSeconds());
    }
}

