/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.http.client;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import jakarta.annotation.Nonnull;
import java.time.Duration;
import java.time.temporal.ChronoUnit;

public class HttpClientConfiguration {
    public static final String PROP_CONNECTION_TIMEOUT = "plugin.jira-development-integration.cloud.devinfo.connection.timeout";
    public static final String PROP_CALLBACK_THREAD_COUNT = "plugin.jira-development-integration.cloud.devinfo.callback.thread.count";
    public static final String PROP_HTTP_CONNECTION_MAX = "plugin.jira-development-integration.cloud.devinfo.http.connection.max";
    public static final String PROP_HTTP_CONNECTION_HOST_MAX = "plugin.jira-development-integration.cloud.devinfo.http.connection.host.max";
    public static final String PROP_SOCKET_TIMEOUT = "plugin.jira-development-integration.cloud.devinfo.socket.timeout";
    private final ApplicationPropertiesService propertiesService;

    public HttpClientConfiguration(ApplicationPropertiesService propertiesService) {
        this.propertiesService = propertiesService;
    }

    @Nonnull
    public Duration getConnectionTimeout() {
        return Duration.of(this.getLong(PROP_CONNECTION_TIMEOUT, Duration.ofSeconds(20L).toMillis()), ChronoUnit.MILLIS);
    }

    public int getMaxCallbackThreads() {
        return this.getInt(PROP_CALLBACK_THREAD_COUNT, 10);
    }

    public int getMaxHttpConnections() {
        return this.getInt(PROP_HTTP_CONNECTION_MAX, 200);
    }

    public int getMaxHttpConnectionsPerHost() {
        return this.getInt(PROP_HTTP_CONNECTION_HOST_MAX, 5);
    }

    @Nonnull
    public Duration getSocketTimeout() {
        return Duration.of(this.getLong(PROP_SOCKET_TIMEOUT, Duration.ofSeconds(20L).toMillis()), ChronoUnit.MILLIS);
    }

    private int getInt(String key, int defaultValue) {
        return this.propertiesService.getPluginProperty(key, defaultValue);
    }

    private long getLong(String key, long defaultValue) {
        return this.propertiesService.getPluginProperty(key, defaultValue);
    }
}

