/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.http.json;

import com.atlassian.httpclient.api.DefaultResponseTransformation;
import com.atlassian.httpclient.api.HttpClient;
import com.atlassian.httpclient.api.HttpStatus;
import com.atlassian.httpclient.api.Request;
import com.atlassian.httpclient.api.Response;
import com.atlassian.httpclient.api.ResponseTransformation;
import com.atlassian.stash.internal.jira.http.client.auth.AuthorizationHandler;
import com.atlassian.stash.internal.jira.http.client.exception.HttpClientException;
import com.atlassian.stash.internal.jira.http.json.HttpRequestExecutor;
import com.atlassian.stash.internal.jira.http.json.exception.JsonMarshallException;
import com.atlassian.stash.internal.jira.http.json.exception.JsonUnmarshallException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.atlassian.util.concurrent.Promise;
import io.atlassian.util.concurrent.Promises;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpRequestExecutor
implements HttpRequestExecutor {
    private static final Logger log = LoggerFactory.getLogger(DefaultHttpRequestExecutor.class);
    private final AuthorizationHandler authorizationHandler;
    private final HttpClient httpClient;
    private final ObjectMapper objectMapper;

    public DefaultHttpRequestExecutor(HttpClient httpClient, AuthorizationHandler authorizationHandler) {
        this.httpClient = httpClient;
        this.authorizationHandler = authorizationHandler;
        this.objectMapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }

    @Override
    public Promise<Response> makeDeleteRequest(String url) {
        log.trace("Sending DELETE request to {}", (Object)url);
        return this.genericExceptionWrapper(() -> {
            ResponseTransformation.Builder responseBuilder = DefaultResponseTransformation.builder();
            Request.Builder builder = this.httpClient.newRequest(url);
            Request.Builder authorizedRequest = this.authorizationHandler.apply(builder);
            return authorizedRequest.delete().transform((ResponseTransformation)responseBuilder.on(HttpStatus.ACCEPTED, Function.identity()).others(response -> {
                throw new HttpClientException((Response)response);
            }).build());
        });
    }

    @Override
    public <T> Promise<T> makeGetRequest(String url, Class<T> returnType) {
        log.trace("Sending GET request to {}", (Object)url);
        return this.genericExceptionWrapper(() -> {
            ResponseTransformation.Builder responseBuilder = DefaultResponseTransformation.builder();
            Request.Builder builder = this.httpClient.newRequest(url);
            Request.Builder authorizedRequest = this.authorizationHandler.apply(builder);
            return authorizedRequest.setAccept("application/json").get().transform((ResponseTransformation)responseBuilder.ok(response -> this.unmarshall((Response)response, returnType)).others(response -> {
                throw new HttpClientException((Response)response);
            }).build());
        });
    }

    @Override
    public <T, R> Promise<R> makePostRequest(String url, T requestPayload, Class<R> returnType) {
        String jsonPayload = this.marshall(Objects.requireNonNull(requestPayload, "requestPayload"));
        log.trace("Sending POST request to {} with payload: {}", (Object)url, (Object)jsonPayload);
        return this.genericExceptionWrapper(() -> {
            Request.Builder builder = this.httpClient.newRequest(url);
            ResponseTransformation.Builder responseBuilder = DefaultResponseTransformation.builder();
            Request.Builder authorizedRequest = this.authorizationHandler.apply(builder);
            return ((Request.Builder)((Request.Builder)authorizedRequest.setAccept("application/json").setContentType("application/json")).setEntity(jsonPayload)).post().transform((ResponseTransformation)responseBuilder.ok(response -> this.unmarshall((Response)response, returnType)).on(HttpStatus.ACCEPTED, response -> this.unmarshall((Response)response, returnType)).others(response -> {
                throw new HttpClientException((Response)response);
            }).build());
        });
    }

    private <R> Promise<R> genericExceptionWrapper(Supplier<Promise<R>> supplier) {
        try {
            return supplier.get();
        }
        catch (Exception ex) {
            return Promises.rejected((Throwable)ex);
        }
    }

    private <T> String marshall(T requestPayload) {
        try {
            return this.objectMapper.writeValueAsString(requestPayload);
        }
        catch (IOException e) {
            log.debug("Unable to marshall request payload: ", (Throwable)e);
            throw new JsonMarshallException("Unable to marshall request payload ", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T unmarshall(Response response, Class<T> returnType) {
        try (InputStream body = response.getEntityStream();){
            Object object = this.objectMapper.readValue(body, returnType);
            return (T)object;
        }
        catch (IOException e) {
            log.debug("Unable to unmarshall json response: ", (Throwable)e);
            throw new JsonUnmarshallException("Unable to unmarshall json response", e);
        }
    }
}

