/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.index.IndexResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;

public abstract class AbstractIndexedResult
implements IndexResult {
    private final String issueKey;
    private final Repository repository;
    private final String refId;
    private final Date lastUpdated;

    protected AbstractIndexedResult(@Nonnull Repository repository, @Nonnull String issueKey, @Nonnull String refId, @Nullable Date lastUpdated) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.issueKey = Objects.requireNonNull(issueKey, "issueKey");
        this.refId = Objects.requireNonNull(refId, "refId");
        this.lastUpdated = lastUpdated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractIndexedResult that = (AbstractIndexedResult)o;
        return Objects.equals(this.issueKey, that.issueKey) && Objects.equals(this.repository, that.repository) && Objects.equals(this.refId, that.refId);
    }

    @Override
    @Nonnull
    public String getIssueKey() {
        return this.issueKey;
    }

    @Override
    @Nullable
    public Date getLastUpdated() {
        return this.lastUpdated;
    }

    @Override
    @Nonnull
    public String getRefId() {
        return this.refId;
    }

    @Override
    @Nonnull
    public Repository getRepository() {
        return this.repository;
    }

    public int hashCode() {
        return Objects.hash(this.issueKey, this.repository, this.refId);
    }
}

