/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index;

import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.jira.index.JiraDeploymentIndexService;
import com.atlassian.stash.internal.jira.index.ao.IndexedDeploymentDao;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class DefaultJiraDeploymentIndexService
implements JiraDeploymentIndexService {
    private final IndexedDeploymentDao indexedDeploymentDao;
    private final TransactionTemplate transactionTemplate;

    public DefaultJiraDeploymentIndexService(IndexedDeploymentDao indexedDeploymentDao, TransactionTemplate transactionTemplate) {
        this.indexedDeploymentDao = indexedDeploymentDao;
        this.transactionTemplate = transactionTemplate;
    }

    @Override
    public void deleteByDeploymentId(long deploymentId) {
        this.transactionTemplate.execute(() -> {
            this.indexedDeploymentDao.deleteByDeploymentId(deploymentId);
            return null;
        });
    }

    @Override
    public void deleteByRepositoryId(int repositoryId) {
        this.transactionTemplate.execute(() -> {
            this.indexedDeploymentDao.deleteByRepositoryId(repositoryId);
            return null;
        });
    }

    @Override
    @Nonnull
    public Set<String> findIssueKeys(long deploymentId) {
        return this.indexedDeploymentDao.getJiraIssueKeys(deploymentId);
    }

    @Override
    public void index(long deploymentId, int repositoryId, @Nonnull Set<String> issueKeys) {
        if (!issueKeys.isEmpty()) {
            this.transactionTemplate.execute(() -> {
                this.indexedDeploymentDao.index(deploymentId, repositoryId, issueKeys);
                return null;
            });
        }
    }
}

