/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index;

import com.atlassian.bitbucket.AuthorisationException;
import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.BranchCallback;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryBranchesRequest;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.jira.change.BranchChange;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.index.IssueUpdateQueue;
import com.atlassian.stash.internal.jira.index.IssueUpdates;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import com.atlassian.stash.internal.jira.index.ao.AoJiraIndexResult;
import com.atlassian.stash.internal.jira.index.ao.JiraIndexDao;
import com.atlassian.stash.internal.jira.index.ao.SequenceNumber;
import com.atlassian.stash.internal.jira.index.ao.UpdatedIssuesDao;
import com.atlassian.stash.internal.jira.index.branch.IndexedBranch;
import com.atlassian.stash.internal.jira.index.pull.IndexedPullRequest;
import com.atlassian.stash.internal.jira.index.pull.PullRequestReindexer;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraIndexService
implements JiraIndexService {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraIndexService.class);
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final I18nService i18nService;
    private final JiraIndexDao indexDao;
    private final JiraIssueScanner issueScanner;
    private final int maxUpdatedIssues;
    private final PullRequestReindexer pullRequestReindexer;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final TransactionTemplate transactionTemplate;
    private final UpdatedIssuesDao updatedIssuesDao;
    private final IssueUpdateQueue updateQueue;
    private final PermissionValidationService validationService;

    public DefaultJiraIndexService(Anonymous2LORequestVerifier anonymous2LORequestVerifier, I18nService i18nService, JiraIndexDao indexDao, JiraIssueScanner issueScanner, ApplicationPropertiesService propertiesService, PullRequestReindexer pullRequestReindexer, RefService refService, RepositoryService repositoryService, TransactionTemplate transactionTemplate, UpdatedIssuesDao updatedIssuesDao, IssueUpdateQueue updateQueue, PermissionValidationService validationService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.i18nService = i18nService;
        this.indexDao = indexDao;
        this.issueScanner = issueScanner;
        this.pullRequestReindexer = pullRequestReindexer;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.transactionTemplate = transactionTemplate;
        this.updatedIssuesDao = updatedIssuesDao;
        this.updateQueue = updateQueue;
        this.validationService = validationService;
        this.maxUpdatedIssues = propertiesService.getPluginProperty("plugin.jira-development-integration.issues.updated.max", 1000);
    }

    @Override
    @Nonnull
    public Set<String> delete(int repositoryId) {
        this.validationService.validateForRepository(repositoryId, Permission.REPO_ADMIN);
        return (Set)this.transactionTemplate.execute(() -> (Set)this.delete(this.indexDao.findByRepository(repositoryId)).collect(MoreCollectors.toImmutableSet()));
    }

    @Override
    @Nonnull
    public Set<String> delete(int repositoryId, long pullRequestId) {
        this.validationService.validateForRepository(repositoryId, Permission.REPO_ADMIN);
        return (Set)this.transactionTemplate.execute(() -> (Set)this.delete(this.indexDao.findByPullRequest(repositoryId, pullRequestId)).collect(MoreCollectors.toImmutableSet()));
    }

    @Override
    @Nonnull
    public Map<String, List<IndexResult>> find(@Nonnull Iterable<String> issueKeys) {
        Objects.requireNonNull(issueKeys, "issueKeys");
        try (Timer ignored = TimerUtils.start((String)String.format("Jira dev integration: Find %s issue keys", Iterables.size(issueKeys)));){
            Map results = this.indexDao.findByIssueKeys(issueKeys).stream().collect(Collectors.groupingBy(AoJiraIndexResult::getRepositoryId)).entrySet().stream().flatMap(this::toRepositoryPair).flatMap(pair -> {
                Repository repository = (Repository)pair.getKey();
                return ((List)pair.getValue()).stream().map(result -> DefaultJiraIndexService.toIndexResult(repository, result));
            }).collect(Collectors.groupingBy(IndexResult::getIssueKey, Collectors.mapping(Function.identity(), MoreCollectors.toImmutableList())));
            ImmutableMap immutableMap = Maps.toMap(issueKeys, key -> (List)results.getOrDefault(key, ImmutableList.of()));
            return immutableMap;
        }
    }

    @Override
    @Nonnull
    public IssueUpdates findUpdatedIssues(@Nonnull String sequenceNumber, int maxResults) {
        Objects.requireNonNull(sequenceNumber, "sequenceNumber");
        this.validateTrustedOrHasAdmin();
        if (maxResults < 1) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.index.service.request.limit.invalid", new Object[]{maxResults}));
        }
        try {
            return this.updatedIssuesDao.findUpdatedIssues(SequenceNumber.parse(sequenceNumber), Math.min(maxResults, this.maxUpdatedIssues));
        }
        catch (IllegalArgumentException e) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.rest.issue.updated.param.invalid", new Object[]{"sequenceNo", sequenceNumber}));
        }
    }

    @Override
    @Nonnull
    public Set<String> index(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return (Set)this.transactionTemplate.execute(() -> {
            Set<String> issueKeys = this.issueScanner.scan(pullRequest);
            issueKeys.forEach(issueKey -> this.indexDao.create(new IndexedPullRequest((String)issueKey, pullRequest)));
            this.updateIssueActivity(issueKeys);
            return issueKeys;
        });
    }

    @Override
    @Nonnull
    public Set<String> indexCommits(@Nonnull PullRequest pullRequest, @Nonnull List<Commit> commits) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        Objects.requireNonNull(commits, "commits");
        return (Set)this.transactionTemplate.execute(() -> {
            Set<String> issueKeys = this.issueScanner.scan(commits);
            this.createMissingEntries(pullRequest, issueKeys);
            this.updateIssueActivity(issueKeys);
            return issueKeys;
        });
    }

    @Override
    @Nonnull
    public Set<String> indexTitle(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        return (Set)this.transactionTemplate.execute(() -> {
            Set<String> issueKeys = this.issueScanner.scan(pullRequest.getTitle());
            this.createMissingEntries(pullRequest, issueKeys);
            this.updateIssueActivity(issueKeys);
            return issueKeys;
        });
    }

    @Override
    @Nonnull
    public Set<String> reindex(@Nonnull PullRequest pullRequest) {
        try (Ticker ignored = Timers.timer((String)"jira: reindex pull request").start(new Object[]{pullRequest.getToRef().getRepository().getId(), pullRequest.getId()});){
            Set<String> set = this.pullRequestReindexer.reindex(pullRequest);
            return set;
        }
    }

    @Override
    public void reindex(@Nonnull Repository repository) {
        this.reindex(repository, false);
    }

    @Override
    public void reindex(final @Nonnull Repository repository, boolean withCommits) {
        Objects.requireNonNull(repository, "repository");
        try (Ticker ignored1 = Timers.timer((String)"jira: reindex repository").start(new Object[]{repository.getId(), withCommits});){
            Set issueKeys;
            try (Ticker ignored2 = Timers.start((String)"jira: delete index entries");){
                log.info("{}: Deleting existing index entries", (Object)repository);
                issueKeys = this.delete(repository.getId());
                log.debug("{}: Deleted index entries for {} issue keys", (Object)repository, (Object)issueKeys.size());
                this.updateIssueActivity(issueKeys);
            }
            if (this.repositoryService.isEmpty(repository)) {
                log.info("{}: Nothing to reindex; the repository is empty", (Object)repository);
                return;
            }
            ignored2 = Timers.start((String)"jira: reindex branch names");
            try {
                log.info("{}: Reindexing branch names", (Object)repository);
                issueKeys = (Set)this.transactionTemplate.execute(() -> {
                    final Date now = new Date();
                    final HashSet updated = new HashSet();
                    this.refService.streamBranches(new RepositoryBranchesRequest.Builder(repository).build(), new BranchCallback(){

                        public boolean onBranch(@Nonnull Branch branch) {
                            DefaultJiraIndexService.this.toIndexedBranch(repository, (MinimalRef)branch, now).map(DefaultJiraIndexService.this.indexDao::create).map(AoJiraIndexResult::getIssue).forEach(updated::add);
                            return true;
                        }
                    });
                    return updated;
                });
                log.debug("{}: Branch names indexed {} issue keys", (Object)repository, (Object)issueKeys.size());
                this.updateIssueActivity(issueKeys);
            }
            finally {
                if (ignored2 != null) {
                    ignored2.close();
                }
            }
            ignored2 = Timers.start((String)"jira: reindex pull requests");
            try {
                log.info("{}: Reindexing pull requests{}", (Object)repository, (Object)(withCommits ? " with commits" : ""));
                this.pullRequestReindexer.reindexAll(repository, withCommits);
            }
            finally {
                if (ignored2 != null) {
                    ignored2.close();
                }
            }
        }
    }

    @Override
    public Collection<BranchChange> update(@Nonnull Repository repository, @Nonnull Collection<RefChange> refChanges, @Nonnull Date lastUpdated) {
        return (Collection)this.transactionTemplate.execute(() -> {
            Map<String, List<RefChange>> branchNameToRefChange = refChanges.stream().collect(Collectors.groupingBy(refChange -> refChange.getRef().getId()));
            Map<RefChangeType, List<RefChange>> changesByType = refChanges.stream().collect(Collectors.groupingBy(RefChange::getType));
            Stream<Object> deletedIssues = Stream.empty();
            List<RefChange> changesToDelete = changesByType.get(RefChangeType.DELETE);
            if (CollectionUtils.isNotEmpty(changesToDelete)) {
                Set branches = (Set)changesToDelete.stream().map(RefChange::getRef).map(MinimalRef::getId).collect(MoreCollectors.toImmutableSet());
                deletedIssues = this.delete(this.indexDao.findByBranches(repository.getId(), branches), branchNameToRefChange);
            }
            Stream createdIssues = changesByType.getOrDefault(RefChangeType.ADD, Collections.emptyList()).stream().flatMap(this.toIndexedBranch(repository, lastUpdated)).map(this.indexDao::create).collect(Collectors.groupingBy(AoJiraIndexResult::getBranch)).entrySet().stream().map(this::toBranchNameToIssueKeys).flatMap(entry -> this.toBranchChange((Map.Entry<String, Set<String>>)entry, branchNameToRefChange, RefChangeType.ADD));
            Stream<Object> updatedIssues = Stream.empty();
            List<RefChange> changesToUpdate = changesByType.get(RefChangeType.UPDATE);
            if (CollectionUtils.isNotEmpty(changesToUpdate)) {
                Set branches = (Set)changesToUpdate.stream().map(RefChange::getRef).map(MinimalRef::getId).collect(MoreCollectors.toImmutableSet());
                updatedIssues = this.indexDao.findByBranches(repository.getId(), branches).stream().peek(aoResult -> {
                    aoResult.setUpdatedDate(lastUpdated);
                    aoResult.save();
                }).collect(Collectors.groupingBy(AoJiraIndexResult::getBranch)).entrySet().stream().map(this::toBranchNameToIssueKeys).flatMap(entry -> this.toBranchChange((Map.Entry<String, Set<String>>)entry, branchNameToRefChange, RefChangeType.UPDATE));
            }
            Set branchChanges = (Set)Stream.concat(Stream.concat(createdIssues, deletedIssues), updatedIssues).collect(MoreCollectors.toImmutableSet());
            Set<String> issueKeys = branchChanges.stream().map(BranchChange::getIssueKeys).flatMap(Collection::stream).collect(Collectors.toSet());
            this.updateIssueActivity(issueKeys);
            return branchChanges;
        });
    }

    @Override
    public void updateIssueActivity(@Nonnull Set<String> issueKeys) {
        this.updateQueue.offer(issueKeys);
    }

    private void createMissingEntries(@Nonnull PullRequest pullRequest, Set<String> issueKeys) {
        if (!issueKeys.isEmpty()) {
            HashSet<String> newIssues = new HashSet<String>(issueKeys);
            this.indexDao.findByPullRequest(pullRequest).stream().peek(result -> {
                result.setUpdatedDate(pullRequest.getUpdatedDate());
                result.setPullRequestState(pullRequest.getState());
                result.save();
            }).map(AoJiraIndexResult::getIssue).forEach(newIssues::remove);
            newIssues.stream().map(issueKey -> new IndexedPullRequest((String)issueKey, pullRequest)).forEach(this.indexDao::create);
        }
    }

    private Stream<String> delete(List<AoJiraIndexResult> results) {
        this.indexDao.delete(results);
        return results.stream().map(AoJiraIndexResult::getIssue);
    }

    private Stream<BranchChange> delete(List<AoJiraIndexResult> results, Map<String, List<RefChange>> refLookup) {
        this.indexDao.delete(results);
        return results.stream().collect(Collectors.groupingBy(AoJiraIndexResult::getBranch)).entrySet().stream().map(this::toBranchNameToIssueKeys).flatMap(entry -> this.toBranchChange((Map.Entry<String, Set<String>>)entry, refLookup, RefChangeType.DELETE));
    }

    private Stream<BranchChange> toBranchChange(Map.Entry<String, Set<String>> branchNameToKeys, Map<String, List<RefChange>> branchNameToRefChanges, RefChangeType type) {
        String branchName = branchNameToKeys.getKey();
        return branchNameToRefChanges.get(branchName).stream().filter(refChange -> refChange.getType() == type).map(refChange -> new BranchChange((RefChange)refChange, (Set)branchNameToKeys.getValue()));
    }

    private Map.Entry<String, Set<String>> toBranchNameToIssueKeys(Map.Entry<String, List<AoJiraIndexResult>> branchToResult) {
        return Maps.immutableEntry((Object)branchToResult.getKey(), branchToResult.getValue().stream().map(AoJiraIndexResult::getIssue).collect(Collectors.toSet()));
    }

    private Function<RefChange, Stream<? extends IndexedBranch>> toIndexedBranch(@Nonnull Repository repository, @Nullable Date lastUpdated) {
        return refChange -> this.toIndexedBranch(repository, refChange.getRef(), lastUpdated);
    }

    private Stream<? extends IndexedBranch> toIndexedBranch(@Nonnull Repository repository, @Nonnull MinimalRef ref, @Nullable Date lastUpdated) {
        return this.issueScanner.scan(ref).stream().map(issueKey -> new IndexedBranch(repository, (String)issueKey, ref.getId(), lastUpdated));
    }

    private Stream<? extends ImmutablePair<Repository, List<AoJiraIndexResult>>> toRepositoryPair(Map.Entry<Integer, List<AoJiraIndexResult>> result) {
        try {
            Repository repository = this.repositoryService.getById(result.getKey().intValue());
            if (repository != null) {
                return Stream.of(ImmutablePair.of((Object)repository, result.getValue()));
            }
        }
        catch (AuthorisationException authorisationException) {
            // empty catch block
        }
        return Stream.empty();
    }

    private static IndexResult toIndexResult(Repository repository, AoJiraIndexResult result) {
        if (result.getPullRequestId() == null) {
            return new IndexedBranch(repository, result.getIssue(), result.getBranch(), result.getUpdatedDate());
        }
        return new IndexedPullRequest(repository, result.getIssue(), result.getBranch(), result.getUpdatedDate(), result.getPullRequestId(), result.getPullRequestState());
    }

    private void validateTrustedOrHasAdmin() {
        if (!this.anonymous2LORequestVerifier.isValid("REPO_READ")) {
            this.validationService.validateForGlobal(Permission.ADMIN);
        }
    }
}

