/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index;

import com.atlassian.bitbucket.concurrent.LockService;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.Timer;
import com.atlassian.bitbucket.util.TimerUtils;
import com.atlassian.bitbucket.util.concurrent.LockGuard;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.jira.index.IssueUpdateQueue;
import com.atlassian.stash.internal.jira.index.ao.UpdatedIssuesDao;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IssueUpdateProcessor
implements IssueUpdateQueue {
    static final boolean DEFAULT_UPDATED_ISSUES_ENABLED = true;
    private static final String LOCK_NAME = "bitbucket:jira-development-integration:update-issue-activity";
    private static final long LOCK_TIMEOUT_SECONDS = 60L;
    private static final Logger log = LoggerFactory.getLogger(IssueUpdateProcessor.class);
    private final boolean enabled;
    private final LockService lockService;
    private final TransactionTemplate transactionTemplate;
    private final UpdatedIssuesDao updatedIssuesDao;
    private final BlockingQueue<Set<String>> updateQueue;
    private volatile Thread processor;
    private volatile boolean running;

    public IssueUpdateProcessor(LockService lockService, ApplicationPropertiesService propertiesService, TransactionTemplate transactionTemplate, UpdatedIssuesDao updatedIssuesDao) {
        this.lockService = lockService;
        this.transactionTemplate = transactionTemplate;
        this.updatedIssuesDao = updatedIssuesDao;
        this.enabled = propertiesService.getPluginProperty("plugin.jira-development-integration.issues.updated.enabled", true);
        this.updateQueue = new LinkedBlockingQueue<Set<String>>();
        if (!this.enabled) {
            log.info("Updated issue key journal has been disabled");
        }
    }

    @Override
    public void offer(@Nonnull Set<String> keys) {
        if (Objects.requireNonNull(keys, "keys").isEmpty()) {
            return;
        }
        if (this.enabled && !this.updateQueue.offer(keys)) {
            log.warn("Updated issues queue is full. Dropping update for {} issues{}.", (Object)keys.size(), log.isDebugEnabled() ? ": " + keys.stream().limit(10L).collect(Collectors.joining(", ")) : "");
        }
    }

    public void start() {
        if (this.enabled) {
            this.running = true;
            this.processor = this.createThread();
            this.processor.start();
            log.debug("Started processor thread");
        } else {
            log.debug("Not starting processor thread; updated issues are disabled");
        }
    }

    public void stop() {
        this.running = false;
        Thread processor = this.processor;
        if (processor == null) {
            log.debug("The processor thread is not running");
        } else if (processor.isAlive()) {
            processor.interrupt();
        }
    }

    boolean isRunning() {
        Thread processor = this.processor;
        return processor != null && processor.isAlive();
    }

    void processQueue() throws InterruptedException {
        ArrayList<Set<String>> tasks = new ArrayList<Set<String>>();
        tasks.add(this.updateQueue.take());
        this.updateQueue.drainTo(tasks);
        HashSet keys = new HashSet();
        tasks.forEach(keys::addAll);
        tasks = null;
        try (Timer timer = TimerUtils.start((String)"Issue updates: Acquire lock");
             LockGuard guard = LockGuard.tryLock((Lock)this.lockService.getLock(LOCK_NAME), (long)60L, (TimeUnit)TimeUnit.SECONDS);){
            if (guard == null) {
                boolean debug = log.isDebugEnabled();
                log.warn("Lock to update issue activity time could not be acquired. Dropping update for {} issues{}.", (Object)keys.size(), debug ? ": " + String.valueOf(keys) : "");
                return;
            }
            timer.mark("Issue updates: Apply");
            this.transactionTemplate.execute(() -> {
                this.updatedIssuesDao.update(keys, System.currentTimeMillis());
                return null;
            });
        }
    }

    private Thread createThread() {
        Thread thread = new Thread(() -> {
            while (this.running) {
                try {
                    this.processQueue();
                }
                catch (InterruptedException e) {
                    if (!this.running) continue;
                    Thread.currentThread().interrupt();
                }
            }
        }, "IssueUpdateThread");
        thread.setDaemon(true);
        thread.setUncaughtExceptionHandler((t, e) -> {
            if (this.running) {
                log.warn("{} failed; the thread will be restarted", (Object)t.getName(), (Object)e);
                this.processor = this.createThread();
                this.processor.start();
            } else {
                log.warn("{} failed, but will not be restarted due to system shutdown", (Object)t.getName());
            }
        });
        return thread;
    }
}

