/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.stash.internal.jira.index.ao.AoIndexedDeploymentIssue;
import com.atlassian.stash.internal.jira.index.ao.IndexedDeploymentDao;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class AoIndexedDeploymentDao
implements IndexedDeploymentDao {
    private final ActiveObjects ao;

    public AoIndexedDeploymentDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    public void deleteByDeploymentId(long deploymentId) {
        this.ao.deleteWithSQL(AoIndexedDeploymentIssue.class, "DEPLOYMENT_ID = ?", new Object[]{deploymentId});
    }

    @Override
    public void deleteByRepositoryId(int repositoryId) {
        this.ao.deleteWithSQL(AoIndexedDeploymentIssue.class, "REPOSITORY_ID = ?", new Object[]{repositoryId});
    }

    @Override
    @Nonnull
    public Set<String> getJiraIssueKeys(long deploymentId) {
        AoIndexedDeploymentIssue[] issues = (AoIndexedDeploymentIssue[])this.ao.find(AoIndexedDeploymentIssue.class, "DEPLOYMENT_ID = ?", new Object[]{deploymentId});
        return Arrays.stream(issues).map(AoIndexedDeploymentIssue::getIssueKey).collect(Collectors.toSet());
    }

    @Override
    public void index(long deploymentId, int repositoryId, @Nonnull Set<String> jiraIssueKeys) {
        if (!this.getJiraIssueKeys(deploymentId).isEmpty()) {
            throw new UnsupportedOperationException("Deployment with id " + deploymentId + " has already been indexed and cannot be updated");
        }
        jiraIssueKeys.forEach(issueKey -> this.ao.create(AoIndexedDeploymentIssue.class, (Map)ImmutableMap.builder().put((Object)"DEPLOYMENT_ID", (Object)deploymentId).put((Object)"REPOSITORY_ID", (Object)repositoryId).put((Object)"ISSUE_KEY", issueKey).build()));
    }
}

