/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.index.ao.AoJiraIndexResult;
import com.atlassian.stash.internal.jira.index.ao.JiraIndexDao;
import com.atlassian.stash.internal.jira.index.pull.IndexedPullRequest;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.java.ao.Query;
import net.java.ao.RawEntity;

public class AoJiraIndexDao
implements JiraIndexDao {
    private final ActiveObjects ao;

    public AoJiraIndexDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    @Nonnull
    public AoJiraIndexResult create(@Nonnull IndexResult result) {
        Objects.requireNonNull(result, "result");
        Objects.requireNonNull(result.getLastUpdated(), "lastUpdated");
        return (AoJiraIndexResult)this.ao.create(AoJiraIndexResult.class, AoJiraIndexDao.getProperties(result));
    }

    @Override
    public void delete(@Nonnull Collection<AoJiraIndexResult> results) {
        for (List partition : Iterables.partition(results, (int)100)) {
            this.ao.delete((RawEntity[])partition.toArray(new AoJiraIndexResult[0]));
        }
    }

    @Override
    @Nonnull
    public List<AoJiraIndexResult> findByBranches(int repositoryId, @Nonnull Iterable<String> branches) {
        Objects.requireNonNull(branches, "branches");
        ArrayList<AoJiraIndexResult> results = new ArrayList<AoJiraIndexResult>();
        for (List partition : Iterables.partition(branches, (int)100)) {
            int count = partition.size();
            Object[] parameters = new Object[1 + count];
            parameters[0] = repositoryId;
            parameters[1] = partition.get(0);
            StringBuilder builder = new StringBuilder(50).append("REPOSITORY").append(" = ? AND ").append("PR_ID").append(" IS NULL AND ").append("BRANCH");
            if (count == 1) {
                builder.append(" = ?");
            } else {
                builder.ensureCapacity(53 + 3 * (count - 1));
                builder.append(" IN (?");
                for (int i = 1; i < count; ++i) {
                    builder.append(", ?");
                    parameters[i + 1] = partition.get(i);
                }
                builder.append(")");
            }
            results.addAll(this.find(builder.toString(), parameters));
        }
        results.trimToSize();
        return Collections.unmodifiableList(results);
    }

    @Override
    @Nonnull
    public List<AoJiraIndexResult> findByIssueKeys(@Nonnull Iterable<String> issueKeys) {
        Objects.requireNonNull(issueKeys, "issueKeys");
        ArrayList<AoJiraIndexResult> results = new ArrayList<AoJiraIndexResult>();
        for (List partition : Iterables.partition(issueKeys, (int)100)) {
            String where;
            int count = partition.size();
            if (count == 1) {
                where = "ISSUE = ?";
            } else {
                StringBuilder builder = new StringBuilder(12 + 3 * (count - 1)).append("ISSUE").append(" IN (?");
                for (int i = 1; i < count; ++i) {
                    builder.append(", ?");
                }
                where = builder.append(")").toString();
            }
            results.addAll(this.find(where, partition.toArray()));
        }
        results.trimToSize();
        return Collections.unmodifiableList(results);
    }

    @Override
    @Nonnull
    public List<AoJiraIndexResult> findByPullRequest(int repositoryId, long pullRequestId) {
        return this.find("REPOSITORY = ? AND PR_ID = ?", repositoryId, pullRequestId);
    }

    @Override
    @Nonnull
    public List<AoJiraIndexResult> findByRepository(int repositoryId) {
        return this.find("REPOSITORY = ?", repositoryId);
    }

    @Override
    public AoJiraIndexResult getById(long id) {
        return (AoJiraIndexResult)this.ao.get(AoJiraIndexResult.class, (Object)id);
    }

    private List<AoJiraIndexResult> find(String where, Object ... parameters) {
        return Arrays.asList((AoJiraIndexResult[])this.ao.find(AoJiraIndexResult.class, Query.select().where(where, parameters)));
    }

    private static Map<String, Object> getProperties(IndexResult result) {
        ImmutableMap.Builder propertiesBuilder = ImmutableMap.builder();
        propertiesBuilder.put((Object)"BRANCH", (Object)result.getRefId());
        propertiesBuilder.put((Object)"ISSUE", (Object)result.getIssueKey());
        propertiesBuilder.put((Object)"REPOSITORY", (Object)result.getRepository().getId());
        propertiesBuilder.put((Object)"LAST_UPDATED", (Object)Objects.requireNonNull(result.getLastUpdated()));
        if (result instanceof IndexedPullRequest) {
            IndexedPullRequest pullRequest = (IndexedPullRequest)result;
            propertiesBuilder.put((Object)"PR_ID", (Object)pullRequest.getId());
            propertiesBuilder.put((Object)"PR_STATE", (Object)pullRequest.getState());
        }
        return propertiesBuilder.build();
    }
}

