/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.ao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.stash.internal.jira.index.IssueUpdates;
import com.atlassian.stash.internal.jira.index.ao.AoUpdatedIssues;
import com.atlassian.stash.internal.jira.index.ao.SequenceNumber;
import com.atlassian.stash.internal.jira.index.ao.UpdatedIssuesDao;
import jakarta.annotation.Nonnull;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletionException;
import net.java.ao.DBParam;
import net.java.ao.EntityStreamCallback;
import net.java.ao.Query;

public class AoUpdatedIssuesDao
implements UpdatedIssuesDao {
    private static final int MAX_KEY_LENGTH = 255;
    private final ActiveObjects ao;

    public AoUpdatedIssuesDao(ActiveObjects ao) {
        this.ao = ao;
    }

    @Override
    @Nonnull
    public IssueUpdates findUpdatedIssues(@Nonnull SequenceNumber sinceSequenceNumber, int maxResults) {
        Objects.requireNonNull(sinceSequenceNumber, "sequenceNumber");
        long since = sinceSequenceNumber.getTimestamp();
        return sinceSequenceNumber.getIssueKey().map(issueKey -> this.findIssueUpdates(since, (String)issueKey, maxResults)).orElse(this.findIssueUpdates(maxResults, since));
    }

    @Override
    public void update(@Nonnull Set<String> issueKeys, long date) {
        issueKeys.stream().filter(key -> key.length() < 255).forEach(key -> {
            AoUpdatedIssues result = (AoUpdatedIssues)this.ao.get(AoUpdatedIssues.class, key);
            if (result == null) {
                this.ao.create(AoUpdatedIssues.class, new DBParam[]{new DBParam("ISSUE", key), new DBParam("UPDATE_TIME", (Object)date)});
            } else {
                result.setUpdateTime(date);
                result.save();
            }
        });
    }

    private IssueUpdates findIssueUpdates(int maxResults, long since) {
        String whereClause = String.format("%s > ?", "UPDATE_TIME");
        Object[] whereClauseParams = new Object[]{since};
        return this.findIssueUpdates(maxResults, since, whereClause, whereClauseParams);
    }

    private IssueUpdates findIssueUpdates(long since, String issueKey, int maxResults) {
        String whereClause = String.format("%s > ? OR (%s = ? AND %s > ?)", "UPDATE_TIME", "UPDATE_TIME", "ISSUE");
        Object[] whereClauseParams = new Object[]{since, since, issueKey};
        return this.findIssueUpdates(maxResults, since, whereClause, whereClauseParams);
    }

    private IssueUpdates findIssueUpdates(int maxResults, long since, String whereClause, Object[] whereClauseParams) {
        IssueUpdatesHandler issueUpdatesHandler = new IssueUpdatesHandler(since, maxResults);
        try {
            this.ao.stream(AoUpdatedIssues.class, Query.select((String)"ISSUE,UPDATE_TIME").where(whereClause, whereClauseParams).order("UPDATE_TIME ASC,ISSUE ASC"), (EntityStreamCallback)issueUpdatesHandler);
        }
        catch (CompletionException completionException) {
            // empty catch block
        }
        return issueUpdatesHandler.getIssueUpdates();
    }

    private static class IssueUpdatesHandler
    implements EntityStreamCallback<AoUpdatedIssues, String> {
        private final Set<String> issueKeys;
        private final int maxResults;
        private String lastIssueKey;
        private long lastTimestamp;
        private boolean moreAvailable;
        private boolean moreRecordsWithLastTimestamp;

        public IssueUpdatesHandler(long sinceTimestamp, int maxResults) {
            this.lastTimestamp = sinceTimestamp;
            this.maxResults = maxResults;
            this.issueKeys = new LinkedHashSet<String>();
        }

        public void onRowRead(AoUpdatedIssues row) {
            String issue;
            if (this.issueKeys.size() >= this.maxResults) {
                this.moreRecordsWithLastTimestamp = row.getUpdateTime() == this.lastTimestamp;
                this.moreAvailable = true;
                throw new CompletionException(null);
            }
            this.lastTimestamp = row.getUpdateTime();
            this.lastIssueKey = issue = row.getIssue();
            this.issueKeys.add(issue);
        }

        public IssueUpdates getIssueUpdates() {
            SequenceNumber lastRecordSequenceNumber = this.moreRecordsWithLastTimestamp ? new SequenceNumber(this.lastTimestamp, this.lastIssueKey) : new SequenceNumber(this.lastTimestamp);
            return new IssueUpdates(this.issueKeys, lastRecordSequenceNumber, this.moreAvailable);
        }
    }
}

