/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.ao;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class SequenceNumber {
    private final String issueKey;
    private final long timestamp;

    public SequenceNumber(long timestamp) {
        this(timestamp, null);
    }

    public SequenceNumber(long timestamp, @Nullable String issueKey) {
        this.timestamp = timestamp;
        this.issueKey = (String)StringUtils.firstNonEmpty((CharSequence[])new String[]{issueKey});
    }

    @Nonnull
    public static SequenceNumber parse(@Nonnull String sequenceNumber) {
        Objects.requireNonNull(sequenceNumber, "sequenceNumber");
        Pattern pattern = Pattern.compile("(?<timestamp>\\d+)(\\|(?<issueKey>\\S+))*");
        Matcher matcher = pattern.matcher(sequenceNumber);
        if (!matcher.matches()) {
            throw new IllegalArgumentException(String.format("Invalid sequenceNumber : '%s'", sequenceNumber));
        }
        long timestamp = Long.parseLong(matcher.group("timestamp"));
        String issueKey = matcher.group("issueKey");
        return new SequenceNumber(timestamp, issueKey);
    }

    @Nonnull
    public Optional<String> getIssueKey() {
        return Optional.ofNullable(this.issueKey);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SequenceNumber that = (SequenceNumber)o;
        return this.timestamp == that.timestamp && Objects.equals(this.issueKey, that.issueKey);
    }

    public int hashCode() {
        return Objects.hash(this.issueKey, this.timestamp);
    }

    public String toString() {
        return this.timestamp + (String)(this.issueKey == null ? "" : "|" + this.issueKey);
    }
}

