/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.commit;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.idx.CommitIndex;
import com.atlassian.bitbucket.idx.CommitIndexer;
import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.idx.IndexingContext;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.CommitChange;
import com.atlassian.stash.internal.jira.change.CommitChangeType;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import com.atlassian.stash.internal.jira.listener.CommitChangeListenerFactory;
import jakarta.annotation.Nonnull;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraCommitIndexer
implements CommitIndexer {
    static final String CTX_KEY = "issue-updated-keys";
    static final String ID = "com.atlassian.bitbucket.JiraKeyIndexer";
    private static final Logger log = LoggerFactory.getLogger(JiraCommitIndexer.class);
    private final CommitIndex commitIndex;
    private final JiraIndexService jiraIndexService;
    private final JiraIssueScanner issueScanner;
    private final CommitChangeListenerFactory commitChangeListenerFactory;

    public JiraCommitIndexer(CommitIndex commitIndex, JiraIndexService jiraIndexService, JiraIssueScanner issueScanner, CommitChangeListenerFactory commitChangeListenerFactory) {
        this.commitIndex = commitIndex;
        this.jiraIndexService = jiraIndexService;
        this.issueScanner = issueScanner;
        this.commitChangeListenerFactory = commitChangeListenerFactory;
    }

    @Nonnull
    public String getId() {
        return ID;
    }

    public boolean isEnabledForRepository(@Nonnull Repository repository) {
        return true;
    }

    public void onAfterIndexing(@Nonnull IndexingContext context) {
        CommitChangeListener repoCommitListener = (CommitChangeListener)context.get(CTX_KEY);
        if (repoCommitListener != null) {
            repoCommitListener.onEnd();
        }
    }

    public void onBeforeIndexing(@Nonnull IndexingContext context) {
        this.getOrCreateRepositoryListener(context).onStart();
    }

    public void onCommitAdded(@Nonnull Commit commit, @Nonnull IndexingContext context) {
        Set<String> issueKeys = this.issueScanner.scan(commit);
        if (issueKeys.isEmpty() || this.existsForOrigin(commit, context)) {
            return;
        }
        log.debug("{} Indexed Jira keys: {}", (Object)commit.getId(), issueKeys);
        this.jiraIndexService.updateIssueActivity(issueKeys);
        issueKeys.forEach(key -> this.commitIndex.addProperty(commit.getId(), "jira-key", key.toUpperCase(Locale.US)));
        CommitChange commitChange = new CommitChange(commit, CommitChangeType.ADDED, issueKeys);
        this.getOrCreateRepositoryListener(context).onCommit(commitChange);
    }

    public void onCommitRemoved(@Nonnull Commit commit, @Nonnull IndexingContext context) {
        Set<String> issueKeys = this.issueScanner.scan(commit);
        if (issueKeys.isEmpty()) {
            return;
        }
        this.jiraIndexService.updateIssueActivity(issueKeys);
        CommitChange commitChange = new CommitChange(commit, CommitChangeType.REMOVED, issueKeys);
        this.getOrCreateRepositoryListener(context).onCommit(commitChange);
    }

    private boolean existsForOrigin(Commit commit, IndexingContext context) {
        IndexedCommit indexedCommit = this.commitIndex.getCommit(commit.getId());
        if (indexedCommit == null) {
            return false;
        }
        Repository repository = context.getRepository();
        return repository.isFork() && indexedCommit.getRepositories().contains(repository.getOrigin());
    }

    @Nonnull
    private CommitChangeListener getOrCreateRepositoryListener(IndexingContext context) {
        CommitChangeListener accumulator = (CommitChangeListener)context.get(CTX_KEY);
        if (accumulator == null) {
            accumulator = this.commitChangeListenerFactory.create(context.getRepository());
            context.put(CTX_KEY, (Object)accumulator);
        }
        return accumulator;
    }
}

