/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.deployment;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.dmz.deployment.DeploymentCommitIndexer;
import com.atlassian.bitbucket.dmz.deployments.Deployment;
import com.atlassian.stash.internal.jira.index.JiraDeploymentIndexService;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Set;

public class JiraDeploymentCommitIndexer
implements DeploymentCommitIndexer {
    private final Deployment deployment;
    private final Set<String> issueKeys = new HashSet<String>();
    private final JiraDeploymentIndexService jiraDeploymentIndexService;
    private final JiraIssueScanner jiraIssueScanner;

    public JiraDeploymentCommitIndexer(Deployment deployment, JiraDeploymentIndexService jiraDeploymentIndexService, JiraIssueScanner jiraIssueScanner) {
        this.deployment = deployment;
        this.jiraDeploymentIndexService = jiraDeploymentIndexService;
        this.jiraIssueScanner = jiraIssueScanner;
    }

    public void onAfterIndexing(boolean truncated) {
        if (!this.issueKeys.isEmpty()) {
            this.jiraDeploymentIndexService.index(this.deployment.getId(), this.deployment.getRepository().getId(), this.issueKeys);
        }
    }

    public void onCommit(@Nonnull Commit commit) {
        this.issueKeys.addAll(this.jiraIssueScanner.scan(commit));
    }
}

