/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.event;

import com.atlassian.bitbucket.dmz.event.SynchronousListener;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeclinedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestDeletedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestEvent;
import com.atlassian.bitbucket.event.pull.PullRequestMergedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestOpenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestParticipantStatusUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReopenedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestRescopedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestReviewersUpdatedEvent;
import com.atlassian.bitbucket.event.pull.PullRequestUpdatedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryDeletedEvent;
import com.atlassian.bitbucket.event.repository.RepositoryRefsChangedEvent;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestAction;
import com.atlassian.bitbucket.pull.RescopeDetails;
import com.atlassian.bitbucket.repository.RefChange;
import com.atlassian.bitbucket.repository.RefChangeType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.repository.sync.RefsSynchronizedEvent;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.jira.change.BranchChange;
import com.atlassian.stash.internal.jira.change.PullRequestChange;
import com.atlassian.stash.internal.jira.index.JiraDeploymentIndexService;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import com.atlassian.stash.internal.jira.listener.BranchChangeListener;
import com.atlassian.stash.internal.jira.listener.PullRequestChangeListener;
import com.atlassian.stash.internal.jira.listener.RepositoryChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.stream.Stream;

@SynchronousListener
public class IndexingEventListener {
    private final BranchChangeListener branchChangeListener;
    private final JiraDeploymentIndexService deploymentIndexService;
    private final JiraIndexService indexService;
    private final PullRequestChangeListener prListener;
    private final RepositoryChangeListener repositoryChangeListener;
    private final ScheduledExecutorService scheduledExecutor;
    private final SecurityService securityService;

    public IndexingEventListener(JiraDeploymentIndexService deploymentIndexService, JiraIndexService indexService, SecurityService securityService, BranchChangeListener branchChangeListener, PullRequestChangeListener prListener, RepositoryChangeListener repositoryChangeListener, ScheduledExecutorService scheduledExecutor) {
        this.deploymentIndexService = deploymentIndexService;
        this.indexService = indexService;
        this.securityService = securityService;
        this.branchChangeListener = branchChangeListener;
        this.prListener = prListener;
        this.repositoryChangeListener = repositoryChangeListener;
        this.scheduledExecutor = scheduledExecutor;
    }

    @EventListener
    public void onPullRequestDeclined(PullRequestDeclinedEvent event) {
        this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)event));
    }

    @EventListener
    public void onPullRequestDeleted(PullRequestDeletedEvent event) {
        this.scheduledExecutor.execute(() -> this.securityService.withPermission(Permission.REPO_ADMIN, "remove indexed results in response to application event").call(() -> {
            PullRequest pullRequest = event.getPullRequest();
            this.deletePullRequest(pullRequest.getToRef().getRepository(), pullRequest.getId());
            return null;
        }));
    }

    @EventListener
    public void onPullRequestOpened(PullRequestOpenedEvent event) {
        this.scheduledExecutor.execute(() -> {
            Set<String> issueKeys = this.indexService.index(event.getPullRequest());
            this.notifyPullRequestListener(event.getPullRequest(), event.getAction(), issueKeys);
        });
    }

    @EventListener
    public void onPullRequestParticipantStatusUpdated(PullRequestParticipantStatusUpdatedEvent event) {
        this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)event));
    }

    @EventListener
    public void onPullRequestReopened(PullRequestReopenedEvent event) {
        this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)event));
    }

    @EventListener
    public void onPullRequestRescoped(PullRequestRescopedEvent event) {
        if (event.isFromHashUpdated()) {
            RescopeDetails addedCommits = event.getAddedCommits();
            RescopeDetails removedCommits = event.getRemovedCommits();
            if (addedCommits != null && addedCommits.getCommits().isEmpty() && addedCommits.getTotal() == 0 && removedCommits != null && removedCommits.getCommits().isEmpty() && removedCommits.getTotal() == 0) {
                return;
            }
            PullRequest pullRequest = event.getPullRequest();
            if (addedCommits == null || addedCommits.getCommits().size() != addedCommits.getTotal() || removedCommits != null) {
                this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)event));
            } else {
                this.scheduledExecutor.execute(() -> {
                    Set<String> issueKeys = this.indexService.indexCommits(pullRequest, addedCommits.getCommits());
                    this.notifyPullRequestListener(event.getPullRequest(), event.getAction(), issueKeys);
                });
            }
        }
    }

    @EventListener
    public void onPullRequestReviewersUpdated(PullRequestReviewersUpdatedEvent event) {
        this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)event));
    }

    @EventListener
    public void onPullRequestUpdated(PullRequestUpdatedEvent event) {
        this.scheduledExecutor.execute(() -> {
            Set<String> issueKeys = Collections.emptySet();
            if (event.getPreviousToBranch() != null && !Objects.equals(event.getPreviousToBranch().getId(), event.getPullRequest().getToRef().getId())) {
                issueKeys = this.indexService.reindex(event.getPullRequest());
            } else if (!Objects.equals(event.getPreviousTitle(), event.getPullRequest().getTitle())) {
                issueKeys = this.indexService.indexTitle(event.getPullRequest());
            }
            if (!issueKeys.isEmpty()) {
                this.notifyPullRequestListener(event.getPullRequest(), event.getAction(), issueKeys);
            }
        });
    }

    @EventListener
    public void onRepositoryDeleted(RepositoryDeletedEvent event) {
        this.scheduledExecutor.execute(() -> {
            int repositoryId = event.getRepository().getId();
            Set issueKeys = (Set)this.securityService.withPermission(Permission.REPO_ADMIN, "remove indexed results in when repository is deleted").call(() -> this.indexService.delete(repositoryId));
            this.deploymentIndexService.deleteByRepositoryId(repositoryId);
            this.repositoryChangeListener.onRepositoryDeleted(event.getRepository(), issueKeys);
        });
    }

    @EventListener
    public void onRepositoryRefsChanged(RepositoryRefsChangedEvent event) {
        List refChanges;
        if (event instanceof PullRequestMergedEvent) {
            this.scheduledExecutor.execute(() -> this.reindexPullRequest((PullRequestEvent)((PullRequestMergedEvent)event)));
            return;
        }
        Stream<RefChange> stream = event.getRefChanges().stream().filter(refChange -> refChange.getRef().getType() == StandardRefType.BRANCH);
        if (event instanceof RefsSynchronizedEvent) {
            stream = stream.filter(refChange -> refChange.getType() == RefChangeType.DELETE);
        }
        if ((refChanges = (List)stream.collect(MoreCollectors.toImmutableList())).isEmpty()) {
            return;
        }
        this.scheduledExecutor.execute(() -> {
            Collection<BranchChange> branchEvents = this.indexService.update(event.getRepository(), refChanges, event instanceof ApplicationEvent ? ((ApplicationEvent)event).getDate() : new Date());
            if (!branchEvents.isEmpty()) {
                this.branchChangeListener.onBranchChanges(event.getRepository(), branchEvents);
            }
        });
    }

    private void deletePullRequest(Repository repository, long pullRequestId) {
        Set<String> issueKeys = this.indexService.delete(repository.getId(), pullRequestId);
        this.prListener.onPullRequestDeleted(repository, pullRequestId, issueKeys);
    }

    private void notifyPullRequestListener(PullRequest pullRequest, PullRequestAction action, Set<String> issueKeys) {
        PullRequestChange pullRequestChange = new PullRequestChange(pullRequest, action, issueKeys);
        this.prListener.onPullRequestUpdated(pullRequestChange);
    }

    private void reindexPullRequest(PullRequestEvent event) {
        this.reindexPullRequest(event.getPullRequest(), event.getAction());
    }

    private void reindexPullRequest(PullRequest pullRequest, PullRequestAction action) {
        Set<String> issueKeys = this.indexService.reindex(pullRequest);
        this.notifyPullRequestListener(pullRequest, action, issueKeys);
    }
}

