/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.event;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import com.atlassian.stash.internal.jira.index.event.RepositoryIndexingRequest;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryIndexer
implements BucketProcessor<RepositoryIndexingRequest> {
    private static final Logger log = LoggerFactory.getLogger(RepositoryIndexer.class);
    private final JiraIndexService jiraIndexService;
    private final RepositoryService repositoryService;
    private final EscalatedSecurityContext withRepoAdmin;

    public RepositoryIndexer(JiraIndexService jiraIndexService, RepositoryService repositoryService, SecurityService securityService) {
        this.jiraIndexService = jiraIndexService;
        this.repositoryService = repositoryService;
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "Repository indexing");
    }

    public void process(@Nonnull String bucketId, @Nonnull List<RepositoryIndexingRequest> tasks) {
        this.withRepoAdmin.call(() -> {
            for (RepositoryIndexingRequest task : tasks) {
                Repository repository = this.repositoryService.getById(task.getRepositoryId());
                if (repository == null) {
                    log.info("[{}] Skipping indexing; it appears the repository has been deleted", (Object)task.getRepositoryId());
                    continue;
                }
                if (repository.getState() == Repository.State.OFFLINE) {
                    log.debug("{}: Skipping indexing; the repository is offline", (Object)repository);
                    continue;
                }
                this.jiraIndexService.reindex(repository);
            }
            return null;
        });
    }
}

