/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.event;

import com.atlassian.bitbucket.concurrent.BucketProcessor;
import com.atlassian.bitbucket.concurrent.BucketedExecutor;
import com.atlassian.bitbucket.concurrent.BucketedExecutorSettings;
import com.atlassian.bitbucket.concurrent.ConcurrencyPolicy;
import com.atlassian.bitbucket.concurrent.ConcurrencyService;
import com.atlassian.bitbucket.event.repository.RepositoryImportedEvent;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.event.api.EventListener;
import com.atlassian.stash.internal.jira.index.event.RepositoryIndexer;
import com.atlassian.stash.internal.jira.index.event.RepositoryIndexingRequest;
import java.io.Serializable;

public class RepositoryIndexingScheduler {
    private static final String BUCKETED_EXECUTOR_NAME = "atl.jira-repository-indexing.import";
    private static final String PROPERTY_REPOSITORY_INDEXING_THREADS = "plugin.bitbucket-development-integration.repository.indexing.import.threads";
    private static final int REPOSITORY_INDEXING_THREADS_DEFAULT = 1;
    private final BucketedExecutor<RepositoryIndexingRequest> executorImport;

    public RepositoryIndexingScheduler(ApplicationPropertiesService propertiesService, ConcurrencyService concurrencyService, RepositoryIndexer repositoryIndexer) {
        int threads = propertiesService.getPluginProperty(PROPERTY_REPOSITORY_INDEXING_THREADS, 1);
        this.executorImport = concurrencyService.getBucketedExecutor(BUCKETED_EXECUTOR_NAME, new BucketedExecutorSettings.Builder(RepositoryIndexingRequest.BUCKET_EXTRACTOR, (BucketProcessor)repositoryIndexer).maxConcurrency(threads, ConcurrencyPolicy.PER_NODE).build());
    }

    @EventListener
    public void onRepositoryImportedEvent(RepositoryImportedEvent event) {
        this.executorImport.submit((Serializable)new RepositoryIndexingRequest(event.getRepository()));
    }

    public void shutdown() {
        this.executorImport.shutdown();
    }
}

