/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.pull;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.commit.graph.SimpleCommitGraphNode;
import com.atlassian.bitbucket.dmz.process.CommitPump;
import com.atlassian.bitbucket.dmz.process.LineStdinHandler;
import com.atlassian.bitbucket.dmz.process.LineStdoutHandler;
import com.atlassian.bitbucket.dmz.pull.DmzPullRequestService;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryField;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryRequest;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestRef;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.scm.CommandInputHandler;
import com.atlassian.bitbucket.scm.CommandOutputHandler;
import com.atlassian.bitbucket.scm.CommandResult;
import com.atlassian.bitbucket.scm.CommandSummary;
import com.atlassian.bitbucket.scm.CommandSummaryHandler;
import com.atlassian.bitbucket.scm.git.command.CommitReaderSettings;
import com.atlassian.bitbucket.scm.git.command.GitCommand;
import com.atlassian.bitbucket.scm.git.command.GitCommandBuilderFactory;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListBuilder;
import com.atlassian.bitbucket.scm.git.command.revlist.GitRevListOrder;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.stash.internal.jira.index.IssueUpdateQueue;
import com.atlassian.stash.internal.jira.index.ao.JiraIndexDao;
import com.atlassian.stash.internal.jira.index.pull.IndexedPullRequest;
import com.atlassian.stash.internal.jira.index.pull.PullRequestReindexContext;
import com.atlassian.stash.internal.jira.index.pull.PullRequestReindexer;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang3.mutable.MutableObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPullRequestReindexer
implements PullRequestReindexer {
    private static final Set<PullRequestSummaryField> SUMMARY_FIELDS = ImmutableSet.of((Object)PullRequestSummaryField.STATE, (Object)PullRequestSummaryField.TITLE, (Object)PullRequestSummaryField.UPDATED_DATE);
    private static final Logger log = LoggerFactory.getLogger(DefaultPullRequestReindexer.class);
    private final int batchSize;
    private final GitCommandBuilderFactory builderFactory;
    private final Duration commandTimeout;
    private final JiraIndexDao indexDao;
    private final JiraIssueScanner issueScanner;
    private final int maxMessageLength;
    private final int pageSize;
    private final DmzPullRequestService pullRequestService;
    private final TransactionTemplate transactionTemplate;
    private final IssueUpdateQueue updateQueue;

    public DefaultPullRequestReindexer(GitCommandBuilderFactory builderFactory, JiraIndexDao indexDao, JiraIssueScanner issueScanner, ApplicationPropertiesService propertiesService, DmzPullRequestService pullRequestService, TransactionTemplate transactionTemplate, IssueUpdateQueue updateQueue) {
        this.builderFactory = builderFactory;
        this.indexDao = indexDao;
        this.issueScanner = issueScanner;
        this.pullRequestService = pullRequestService;
        this.transactionTemplate = transactionTemplate;
        this.updateQueue = updateQueue;
        this.batchSize = propertiesService.getPluginProperty("plugin.jira-development-integration.reindex.pullrequests.size.batch", 500);
        this.commandTimeout = Duration.ofSeconds(Math.max(propertiesService.getPluginProperty("plugin.jira-development-integration.reindex.pullrequests.command.timeout", 300L), 120L));
        this.maxMessageLength = propertiesService.getPluginProperty("plugin.jira-development-integration.reindex.pullrequests.commit.message.max", 16384);
        this.pageSize = propertiesService.getPluginProperty("plugin.jira-development-integration.reindex.pullrequests.size.page", 5000);
        if (this.maxMessageLength < 1) {
            log.info("Reindexing pull requests with commits is disabled (Max message length: {})", (Object)this.maxMessageLength);
        }
    }

    @Override
    public Set<String> reindex(@Nonnull PullRequest p) {
        Objects.requireNonNull(p, "pullRequest");
        log.debug("{}: Reindexing pull request #{}", (Object)p.getToRef().getRepository(), (Object)p.getId());
        return (Set)this.transactionTemplate.execute(() -> {
            PullRequest pullRequest = this.pullRequestService.getById(p.getToRef().getRepository().getId(), p.getId());
            if (pullRequest == null) {
                return Collections.emptySet();
            }
            HashSet<String> issueKeys = new HashSet<String>(this.issueScanner.scan(pullRequest));
            HashSet<String> changedIssues = new HashSet<String>(issueKeys);
            Set toDelete = (Set)this.indexDao.findByPullRequest(pullRequest).stream().filter(result -> {
                if (issueKeys.remove(result.getIssue())) {
                    result.setPullRequestState(pullRequest.getState());
                    result.setUpdatedDate(pullRequest.getUpdatedDate());
                    result.save();
                    return false;
                }
                changedIssues.add(result.getIssue());
                return true;
            }).collect(MoreCollectors.toImmutableSet());
            this.indexDao.delete(toDelete);
            issueKeys.forEach(issueKey -> this.indexDao.create(new IndexedPullRequest((String)issueKey, pullRequest)));
            this.updateQueue.offer(changedIssues);
            return ImmutableSet.copyOf(changedIssues);
        });
    }

    @Override
    public void reindexAll(@Nonnull Repository repository, boolean withCommits) {
        Objects.requireNonNull(repository, "repository");
        if (withCommits) {
            if (this.maxMessageLength < 1) {
                log.info("{}: Reindexing pull requests with commits has been disabled", (Object)repository);
            } else {
                if ("git".equals(repository.getScmId())) {
                    this.reindexAllWithCommits(repository);
                    return;
                }
                log.warn("{}: Reindexing pull requests with commits is not supported for {} repositories", (Object)repository, (Object)repository.getScmId());
            }
        }
        Set updatedIssues = (Set)this.transactionTemplate.execute(() -> {
            HashSet updated = new HashSet();
            PullRequestSummaryRequest summaryRequest = new PullRequestSummaryRequest.Builder(repository).fields(SUMMARY_FIELDS).build();
            PageUtils.toStream(pageRequest -> this.pullRequestService.getSummaries(summaryRequest, pageRequest), (int)this.pageSize).forEach(summary -> this.issueScanner.scan((PullRequestSummary)summary).stream().peek(updated::add).map(issueKey -> new IndexedPullRequest((String)issueKey, (PullRequestSummary)summary)).forEach(this.indexDao::create));
            return updated;
        });
        log.debug("{}: Pull requests indexed {} issue keys", (Object)repository, (Object)updatedIssues.size());
        this.updateQueue.offer(updatedIssues);
    }

    private void reindexAllWithCommits(Repository repository) {
        MutableObject pageRequest = new MutableObject((Object)PageUtils.newRequest((int)0, (int)this.pageSize));
        PullRequestSummaryRequest summaryRequest = new PullRequestSummaryRequest.Builder(repository).fields(SUMMARY_FIELDS).build();
        while (pageRequest.getValue() != null) {
            HashSet alternates = new HashSet();
            ArrayList<PullRequestReindexContext> contexts = new ArrayList<PullRequestReindexContext>(this.pageSize);
            HashSet includes = new HashSet(this.pageSize * 2, 1.0f);
            this.transactionTemplate.execute(() -> {
                Page page = this.pullRequestService.getSummaries(summaryRequest, (PageRequest)pageRequest.getValue());
                pageRequest.setValue((Object)page.getNextPageRequest());
                if (page.getSize() == 0) {
                    return Collections.emptySet();
                }
                log.debug("{}: Building contexts for {} pull requests", (Object)repository, (Object)page.getSize());
                page.forEach(summary -> {
                    PullRequestRef fromRef = summary.getFromRef();
                    String from = fromRef.getLatestCommit();
                    String to = summary.getToRef().getLatestCommit();
                    alternates.add(fromRef.getRepository());
                    contexts.add(new PullRequestReindexContext((PullRequestSummary)summary, new CommitGraphContext.Builder().exclude(to, new String[0]).include(from, new String[0]).build()));
                    includes.add(from);
                    includes.add(to);
                });
                return null;
            });
            if (contexts.isEmpty()) break;
            if (log.isDebugEnabled()) {
                log.debug("{}: Streaming commits from {} tips, using {} alternate(s)", new Object[]{repository, includes.size(), alternates.size()});
            }
            IndexingStdoutHandler handler = new IndexingStdoutHandler(repository, contexts);
            GitCommand command = ((GitRevListBuilder)((GitRevListBuilder)((GitRevListBuilder)((GitRevListBuilder)((GitRevListBuilder)this.builderFactory.builder(repository).revList().alternates(alternates)).format(handler.getFormat())).ignoreMissing(true)).inputHandler((CommandInputHandler)new LineStdinHandler(includes))).order(GitRevListOrder.TOPOLOGICAL)).build((CommandOutputHandler)handler);
            command.setTimeout(this.commandTimeout);
            command.call();
        }
    }

    @Deprecated
    private final class IndexingStdoutHandler
    extends LineStdoutHandler<Void>
    implements CommandSummaryHandler {
        private final List<PullRequestReindexContext> active;
        private final CommitPump commitPump;
        private final List<PullRequestReindexContext> pending;
        private final Repository repository;
        private int totalIssues;

        IndexingStdoutHandler(Repository repository, List<PullRequestReindexContext> active) {
            super(StandardCharsets.UTF_8);
            this.active = active;
            this.commitPump = new CommitPump(new CommitReaderSettings.Builder().maxMessageLength(DefaultPullRequestReindexer.this.maxMessageLength).repository(repository).build(), this::onCommit);
            this.repository = repository;
            this.pending = new ArrayList<PullRequestReindexContext>(DefaultPullRequestReindexer.this.batchSize);
        }

        public Void getOutput() {
            return null;
        }

        public void onComplete(@Nonnull CommandSummary summary) {
            if (summary.getResult() == CommandResult.FAILED) {
                log.warn("{}: Traversal failed after indexing {} issue keys, with {} pull requests unresolved", new Object[]{this.repository, this.totalIssues, this.active.size()});
                return;
            }
            if (this.active.isEmpty()) {
                log.debug("{}: All pull requests were successfully resolved", (Object)this.repository);
            } else {
                log.debug("{}: {} pull requests could not be resolved", (Object)this.repository, (Object)this.active.size());
                this.pending.addAll(this.active);
            }
            if (!this.pending.isEmpty()) {
                this.writeIndex();
            }
            log.debug("{}: Traversal indexed {} issue keys", (Object)this.repository, (Object)this.totalIssues);
        }

        public String getFormat() {
            return this.commitPump.getFormat();
        }

        protected boolean onStdout(@Nonnull String line, boolean truncated) {
            this.commitPump.onStdout(line);
            return !this.active.isEmpty();
        }

        private void onCommit(@Nonnull Commit commit) {
            SimpleCommitGraphNode node = new SimpleCommitGraphNode.Builder(commit).build();
            Set<String> issueKeys = null;
            Iterator<PullRequestReindexContext> iterator = this.active.iterator();
            while (iterator.hasNext()) {
                PullRequestReindexContext context = iterator.next();
                if (context.accept((CommitGraphNode)node) && node.getParents().size() < 2) {
                    if (issueKeys == null) {
                        issueKeys = DefaultPullRequestReindexer.this.issueScanner.scan(commit);
                    }
                    if (!issueKeys.isEmpty()) {
                        context.addIssueKeys(issueKeys);
                    }
                }
                if (!context.isResolved()) continue;
                iterator.remove();
                this.pending.add(context);
                if (this.pending.size() < DefaultPullRequestReindexer.this.batchSize) continue;
                this.writeIndex();
            }
        }

        private void writeIndex() {
            try {
                Set updatedIssues = (Set)DefaultPullRequestReindexer.this.transactionTemplate.execute(() -> {
                    HashSet updated = new HashSet();
                    this.pending.forEach(context -> {
                        context.addIssueKeys(DefaultPullRequestReindexer.this.issueScanner.scan(context.getSummary()));
                        context.stream().peek(updated::add).map(issueKey -> new IndexedPullRequest((String)issueKey, context.getSummary())).forEach(DefaultPullRequestReindexer.this.indexDao::create);
                    });
                    return updated;
                });
                DefaultPullRequestReindexer.this.updateQueue.offer(updatedIssues);
                this.totalIssues += updatedIssues.size();
            }
            catch (Exception e) {
                log.error("{}: Failed to create index entries for {} pull requests", new Object[]{this.repository, this.pending.size(), e});
            }
            this.pending.clear();
        }
    }
}

