/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.pull;

import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummaryField;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestState;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.index.AbstractIndexedResult;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Date;
import java.util.Objects;
import java.util.Optional;

public class IndexedPullRequest
extends AbstractIndexedResult {
    private final long pullRequestId;
    private final PullRequestState pullRequestState;

    public IndexedPullRequest(@Nonnull String issueKey, @Nonnull PullRequest pullRequest) {
        this(Objects.requireNonNull(pullRequest, "pullRequest").getToRef().getRepository(), Objects.requireNonNull(issueKey, "issueKey"), pullRequest.getFromRef().getId(), pullRequest.getUpdatedDate(), pullRequest.getId(), pullRequest.getState());
    }

    public IndexedPullRequest(@Nonnull String issueKey, @Nonnull PullRequestSummary summary) {
        this(Objects.requireNonNull(summary, "summary").getToRef().getRepository(), Objects.requireNonNull(issueKey, "issueKey"), summary.getFromRef().getId(), (Date)IndexedPullRequest.getSummaryField(summary.getUpdatedDate(), PullRequestSummaryField.UPDATED_DATE), summary.getId(), (PullRequestState)IndexedPullRequest.getSummaryField(summary.getState(), PullRequestSummaryField.STATE));
    }

    public IndexedPullRequest(@Nonnull Repository repository, @Nonnull String issueKey, @Nonnull String refId, @Nullable Date lastUpdated, long pullRequestId, @Nonnull PullRequestState pullRequestState) {
        super(repository, issueKey, refId, lastUpdated);
        this.pullRequestId = pullRequestId;
        this.pullRequestState = Objects.requireNonNull(pullRequestState, "pullRequestState");
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexedPullRequest that = (IndexedPullRequest)o;
        return super.equals(o) && that.pullRequestId == this.pullRequestId;
    }

    public long getId() {
        return this.pullRequestId;
    }

    @Nonnull
    public PullRequestState getState() {
        return this.pullRequestState;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.pullRequestId);
    }

    private static <T> T getSummaryField(Optional<T> value, PullRequestSummaryField field) {
        return value.orElseThrow(() -> new IllegalStateException("The PullRequestSummary was loaded without " + String.valueOf(field)));
    }
}

