/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.pull;

import com.atlassian.bitbucket.commit.graph.CommitGraphContext;
import com.atlassian.bitbucket.commit.graph.CommitGraphNode;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import jakarta.annotation.Nonnull;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
class PullRequestReindexContext {
    private final CommitGraphContext graphContext;
    private final PullRequestSummary summary;
    private Set<String> issueKeys;

    PullRequestReindexContext(@Nonnull PullRequestSummary summary, @Nonnull CommitGraphContext graphContext) {
        this.graphContext = Objects.requireNonNull(graphContext, "graphContext");
        this.summary = Objects.requireNonNull(summary, "summary");
    }

    boolean accept(@Nonnull CommitGraphNode node) {
        return this.graphContext.visit(node);
    }

    void addIssueKeys(@Nonnull Set<String> values) {
        if (this.issueKeys == null) {
            this.issueKeys = new HashSet<String>(values);
        } else {
            this.issueKeys.addAll(values);
        }
    }

    @Nonnull
    PullRequestSummary getSummary() {
        return this.summary;
    }

    boolean isResolved() {
        return !this.graphContext.isTraversing();
    }

    @Nonnull
    Stream<String> stream() {
        return this.issueKeys == null || this.issueKeys.isEmpty() ? Stream.empty() : this.issueKeys.stream();
    }
}

