/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.scan;

import com.atlassian.bitbucket.commit.Commit;
import com.atlassian.bitbucket.commit.NoSuchCommitException;
import com.atlassian.bitbucket.dmz.pull.PullRequestSummary;
import com.atlassian.bitbucket.pull.NoSuchPullRequestException;
import com.atlassian.bitbucket.pull.PullRequest;
import com.atlassian.bitbucket.pull.PullRequestCommitsRequest;
import com.atlassian.bitbucket.pull.PullRequestService;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.integration.jira.JiraKeyScanner;
import com.atlassian.stash.internal.jira.index.scan.JiraIssueScanner;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJiraIssueScanner
implements JiraIssueScanner {
    private static final Logger log = LoggerFactory.getLogger(DefaultJiraIssueScanner.class);
    private final JiraKeyScanner jiraKeyScanner;
    private final PullRequestService pullRequestService;

    public DefaultJiraIssueScanner(JiraKeyScanner jiraKeyScanner, PullRequestService pullRequestService) {
        this.jiraKeyScanner = jiraKeyScanner;
        this.pullRequestService = pullRequestService;
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull Iterable<Commit> commits) {
        Objects.requireNonNull(commits, "commits");
        HashSet issueKeys = new HashSet();
        for (Commit commit : commits) {
            Iterables.addAll(issueKeys, this.scanCommit(commit));
        }
        return ImmutableSet.copyOf(issueKeys);
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull Commit commit) {
        return ImmutableSet.copyOf(this.scanCommit(commit));
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull MinimalRef ref) {
        Objects.requireNonNull(ref, "ref");
        return ImmutableSet.copyOf(this.scanRef(ref));
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull PullRequest pullRequest) {
        Objects.requireNonNull(pullRequest, "pullRequest");
        HashSet<String> issueKeys = new HashSet<String>();
        Iterables.addAll(issueKeys, this.scanRef((MinimalRef)pullRequest.getFromRef()));
        Iterables.addAll(issueKeys, (Iterable)this.jiraKeyScanner.findAll((CharSequence)pullRequest.getTitle()));
        this.scanCommits(pullRequest, issueKeys);
        return ImmutableSet.copyOf(issueKeys);
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull PullRequestSummary summary) {
        Objects.requireNonNull(summary, "summary");
        HashSet issueKeys = new HashSet();
        Iterables.addAll(issueKeys, this.scanRef((MinimalRef)summary.getFromRef()));
        summary.getTitle().map(title -> Iterables.addAll((Collection)issueKeys, (Iterable)this.jiraKeyScanner.findAll((CharSequence)title)));
        return ImmutableSet.copyOf(issueKeys);
    }

    @Override
    @Nonnull
    public Set<String> scan(@Nonnull String value) {
        Objects.requireNonNull(value, "value");
        return ImmutableSet.copyOf((Iterable)this.jiraKeyScanner.findAll((CharSequence)value));
    }

    private Iterable<String> scanCommit(Commit commit) {
        String commitMessage = commit.getMessage();
        if (commitMessage == null) {
            return Collections.emptySet();
        }
        return this.jiraKeyScanner.findAll((CharSequence)commitMessage);
    }

    private void scanCommits(PullRequest pullRequest, Set<String> issueKeys) {
        try {
            this.pullRequestService.streamCommits(new PullRequestCommitsRequest.Builder(pullRequest).build(), commit -> {
                if (commit.getParents().size() < 2) {
                    Iterables.addAll((Collection)issueKeys, this.scanCommit(commit));
                }
                return true;
            });
        }
        catch (NoSuchCommitException e) {
            log.warn("{}#{}: Attempted to scan commit messages, but {} has been pruned", new Object[]{pullRequest.getToRef().getRepository(), pullRequest.getId(), e.getCommitId()});
        }
        catch (NoSuchPullRequestException e) {
            log.info("{}#{}: Attempted to scan commit messages, but the pull request no longer exists", (Object)pullRequest.getToRef().getRepository(), (Object)pullRequest.getId());
        }
    }

    private Iterable<String> scanRef(MinimalRef ref) {
        return this.jiraKeyScanner.findAll((CharSequence)ref.getDisplayId());
    }
}

