/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.index.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JiraIndexUpgradeTask
implements PluginUpgradeTask {
    private static final int REPOSITORY_PAGE_SIZE = 100;
    private static final Logger log = LoggerFactory.getLogger(JiraIndexUpgradeTask.class);
    private final ActiveObjects ao;
    private final Executor executor;
    private final JiraIndexService indexService;
    private final RepositoryService repositoryService;
    private final SecurityService securityService;

    public JiraIndexUpgradeTask(ActiveObjects ao, Executor executor, JiraIndexService indexService, RepositoryService repositoryService, SecurityService securityService) {
        this.ao = ao;
        this.executor = executor;
        this.indexService = indexService;
        this.repositoryService = repositoryService;
        this.securityService = securityService;
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.executor.execute(() -> {
            try {
                log.debug("Waiting for AO to initialize");
                this.ao.moduleMetaData().awaitInitialization();
            }
            catch (Exception e) {
                log.error("Error waiting for AO to initialize", (Throwable)e);
                return;
            }
            log.info("Indexing issues in all repositories");
            this.securityService.withPermission(Permission.REPO_ADMIN, this.getShortDescription()).call(() -> {
                PageUtils.toStream(arg_0 -> ((RepositoryService)this.repositoryService).findAll(arg_0), (int)100).forEach(repository -> {
                    log.debug("{}: Indexing issues", repository);
                    try {
                        this.indexService.reindex((Repository)repository);
                    }
                    catch (Exception e) {
                        log.error("{}: Error indexing issues", repository, (Object)e);
                    }
                });
                return null;
            });
            log.info("Indexing completed");
        });
        return Collections.emptyList();
    }

    public int getBuildNumber() {
        return 5;
    }

    public String getShortDescription() {
        return "Index Jira branches in every repository";
    }

    public String getPluginKey() {
        return "com.atlassian.bitbucket.server.bitbucket-jira-development-integration";
    }
}

