/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.jmx;

import com.atlassian.bitbucket.dmz.concurrent.ThreadPoolMXBeanAdapter;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import java.lang.management.ManagementFactory;
import java.util.concurrent.ThreadPoolExecutor;
import javax.management.JMException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorMetrics
implements LifecycleAware {
    private static final Logger log = LoggerFactory.getLogger(ExecutorMetrics.class);
    private static final String MXBEAN_NAME = "com.atlassian.bitbucket.thread-pools:name=JiraDeveloperIntegrationThreadPool";
    private final boolean jmxEnabled;
    private final ThreadPoolExecutor executorService;

    public ExecutorMetrics(ApplicationPropertiesService propertiesService, ThreadPoolExecutor executorService) {
        this.executorService = executorService;
        this.jmxEnabled = propertiesService.isJmxEnabled();
    }

    public void onStart() {
        if (this.jmxEnabled) {
            try {
                ManagementFactory.getPlatformMBeanServer().registerMBean(new ThreadPoolMXBeanAdapter(this.executorService), new ObjectName(MXBEAN_NAME));
            }
            catch (RuntimeException | JMException e) {
                log.warn("Could not register JiraDeveloperIntegrationExecutorMetrics MXBean. Jira development integration executor details will not be available in JMX", (Throwable)e);
            }
        }
    }

    public void onStop() {
        if (this.jmxEnabled) {
            try {
                ManagementFactory.getPlatformMBeanServer().unregisterMBean(new ObjectName(MXBEAN_NAME));
            }
            catch (RuntimeException | JMException e) {
                log.warn("Failed to unregister JiraDeveloperIntegrationExecutorMetrics MXBean", (Throwable)e);
            }
        }
    }
}

