/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.stash.internal.jira.change.BuildStatusChange;
import com.atlassian.stash.internal.jira.listener.BuildStatusChangeListener;
import jakarta.annotation.Nonnull;
import java.util.concurrent.ExecutorService;

public class AsyncBuildStatusChangeListener
implements BuildStatusChangeListener {
    private final BuildStatusChangeListener delegate;
    private final ExecutorService executorService;

    public AsyncBuildStatusChangeListener(BuildStatusChangeListener delegate, ExecutorService executorService) {
        this.executorService = executorService;
        this.delegate = delegate;
    }

    @Override
    public void onBuildStatusDeleted(@Nonnull BuildStatusChange buildStatusChange) {
        this.executorService.execute(() -> this.delegate.onBuildStatusDeleted(buildStatusChange));
    }

    @Override
    public void onBuildStatusSet(@Nonnull BuildStatusChange buildStatusChange) {
        this.executorService.execute(() -> this.delegate.onBuildStatusSet(buildStatusChange));
    }
}

