/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.BranchChange;
import com.atlassian.stash.internal.jira.listener.BranchChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Collection;
import java.util.concurrent.ExecutorService;

public class CompositeBranchChangeListener
implements BranchChangeListener {
    private final ExecutorService executorService;
    private final BranchChangeListener jiraCloudListener;
    private final BranchChangeListener jiraServerListener;

    public CompositeBranchChangeListener(ExecutorService executorService, BranchChangeListener jiraServerListener, BranchChangeListener jiraCloudListener) {
        this.executorService = executorService;
        this.jiraServerListener = jiraServerListener;
        this.jiraCloudListener = jiraCloudListener;
    }

    @Override
    public void onBranchChanges(@Nonnull Repository repository, @Nonnull Collection<BranchChange> branchChanges) {
        this.executorService.execute(() -> this.jiraServerListener.onBranchChanges(repository, branchChanges));
        this.executorService.execute(() -> this.jiraCloudListener.onBranchChanges(repository, branchChanges));
    }
}

