/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.stash.internal.jira.change.CommitChange;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import jakarta.annotation.Nonnull;

public class CompositeCommitChangeListener
implements CommitChangeListener {
    private final CommitChangeListener jiraCloudListener;
    private final CommitChangeListener jiraServerListener;

    public CompositeCommitChangeListener(CommitChangeListener jiraServerListener, CommitChangeListener jiraCloudListener) {
        this.jiraServerListener = jiraServerListener;
        this.jiraCloudListener = jiraCloudListener;
    }

    @Override
    public void onCommit(@Nonnull CommitChange commitChange) {
        this.jiraServerListener.onCommit(commitChange);
        this.jiraCloudListener.onCommit(commitChange);
    }

    @Override
    public void onEnd() {
        this.jiraServerListener.onEnd();
        this.jiraCloudListener.onEnd();
    }

    @Override
    public void onStart() {
        this.jiraServerListener.onStart();
        this.jiraCloudListener.onStart();
    }
}

