/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.listener.CommitChangeListener;
import com.atlassian.stash.internal.jira.listener.CommitChangeListenerFactory;
import com.atlassian.stash.internal.jira.listener.CompositeCommitChangeListener;
import jakarta.annotation.Nonnull;

public class CompositeCommitChangeListenerFactory
implements CommitChangeListenerFactory {
    private final CommitChangeListenerFactory jiraCloudListenerFactory;
    private final CommitChangeListenerFactory jiraServerListenerFactory;

    public CompositeCommitChangeListenerFactory(CommitChangeListenerFactory jiraServerListenerFactory, CommitChangeListenerFactory jiraCloudListenerFactory) {
        this.jiraServerListenerFactory = jiraServerListenerFactory;
        this.jiraCloudListenerFactory = jiraCloudListenerFactory;
    }

    @Override
    public CommitChangeListener create(@Nonnull Repository repository) {
        return new CompositeCommitChangeListener(this.jiraServerListenerFactory.create(repository), this.jiraCloudListenerFactory.create(repository));
    }
}

