/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.change.PullRequestChange;
import com.atlassian.stash.internal.jira.listener.PullRequestChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class CompositePullRequestChangeListener
implements PullRequestChangeListener {
    private final ExecutorService executorService;
    private final PullRequestChangeListener jiraCloudListener;
    private final PullRequestChangeListener jiraServerListener;

    public CompositePullRequestChangeListener(ExecutorService executorService, PullRequestChangeListener jiraServerListener, PullRequestChangeListener jiraCloudListener) {
        this.executorService = executorService;
        this.jiraServerListener = jiraServerListener;
        this.jiraCloudListener = jiraCloudListener;
    }

    @Override
    public void onPullRequestDeleted(@Nonnull Repository repository, @Nonnull Long pullRequestId, @Nonnull Set<String> linkedIssues) {
        this.executorService.execute(() -> this.jiraServerListener.onPullRequestDeleted(repository, pullRequestId, linkedIssues));
        this.executorService.execute(() -> this.jiraCloudListener.onPullRequestDeleted(repository, pullRequestId, linkedIssues));
    }

    @Override
    public void onPullRequestUpdated(@Nonnull PullRequestChange pullRequestChange) {
        this.executorService.execute(() -> this.jiraServerListener.onPullRequestUpdated(pullRequestChange));
        this.executorService.execute(() -> this.jiraCloudListener.onPullRequestUpdated(pullRequestChange));
    }
}

