/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.stash.internal.jira.listener.RepositoryChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Set;
import java.util.concurrent.ExecutorService;

public class CompositeRepositoryChangeListener
implements RepositoryChangeListener {
    private final ExecutorService executorService;
    private final RepositoryChangeListener jiraCloudListener;
    private final RepositoryChangeListener jiraServerListener;

    public CompositeRepositoryChangeListener(ExecutorService executorService, RepositoryChangeListener jiraServerListener, RepositoryChangeListener jiraCloudListener) {
        this.executorService = executorService;
        this.jiraServerListener = jiraServerListener;
        this.jiraCloudListener = jiraCloudListener;
    }

    @Override
    public void onRepositoryDeleted(@Nonnull Repository repository, @Nonnull Set<String> linkedIssues) {
        this.executorService.execute(() -> this.jiraServerListener.onRepositoryDeleted(repository, linkedIssues));
        this.executorService.execute(() -> this.jiraCloudListener.onRepositoryDeleted(repository, linkedIssues));
    }
}

