/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.stash.internal.jira.change.BuildStatusChange;
import com.atlassian.stash.internal.jira.cloud.sync.BuildStatusConfig;
import com.atlassian.stash.internal.jira.listener.BuildStatusChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ConfigurableBuildStatusChangeListener
implements BuildStatusChangeListener {
    private final BuildStatusChangeListener delegate;
    private final BuildStatusConfig buildStatusConfig;

    public ConfigurableBuildStatusChangeListener(BuildStatusChangeListener delegate, BuildStatusConfig buildStatusConfig) {
        this.delegate = delegate;
        this.buildStatusConfig = buildStatusConfig;
    }

    @Override
    public void onBuildStatusDeleted(@Nonnull BuildStatusChange buildStatusChange) {
        Objects.requireNonNull(buildStatusChange, "buildStatusChange");
        if (this.buildStatusConfig.isSendDataEnabled()) {
            this.delegate.onBuildStatusDeleted(buildStatusChange);
        }
    }

    @Override
    public void onBuildStatusSet(@Nonnull BuildStatusChange buildStatusChange) {
        Objects.requireNonNull(buildStatusChange, "buildStatusChange");
        if (this.buildStatusConfig.isSendDataEnabled()) {
            this.delegate.onBuildStatusSet(buildStatusChange);
        }
    }
}

