/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.listener;

import com.atlassian.stash.internal.jira.change.DeploymentChange;
import com.atlassian.stash.internal.jira.cloud.sync.DeploymentConfig;
import com.atlassian.stash.internal.jira.listener.DeploymentChangeListener;
import jakarta.annotation.Nonnull;
import java.util.Objects;

public class ConfigurableDeploymentChangeListener
implements DeploymentChangeListener {
    private final DeploymentConfig deploymentConfig;
    private final DeploymentChangeListener delegate;

    public ConfigurableDeploymentChangeListener(DeploymentChangeListener delegate, DeploymentConfig deploymentConfig) {
        this.delegate = delegate;
        this.deploymentConfig = deploymentConfig;
    }

    @Override
    public void onDeploymentEvent(@Nonnull DeploymentChange deploymentChange) {
        Objects.requireNonNull(deploymentChange, "deploymentChange");
        if (this.deploymentConfig.isSendDataEnabled()) {
            this.delegate.onDeploymentEvent(deploymentChange);
        }
    }
}

