/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.stash.internal.jira.summary.SummaryService;
import com.atlassian.stash.internal.jira.summary.SummaryType;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
@Consumes(value={"application/json"})
@Path(value="/detail")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class DevSummaryDetailResource {
    private static final Logger log = LoggerFactory.getLogger(DevSummaryDetailResource.class);
    private static final int MAX_SUMMARIES = 1000;
    private final SummaryService summaryService;
    private final UrlFactory urlFactory;

    @Inject
    public DevSummaryDetailResource(SummaryService summaryService, UrlFactory urlFactory) {
        this.summaryService = summaryService;
        this.urlFactory = urlFactory;
    }

    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    @GET
    @Path(value="{type}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getIssueSummary(@PathParam(value="type") String type, @Deprecated @QueryParam(value="issue") List<String> issues, @QueryParam(value="globalId") List<String> globalIds) {
        SummaryType summaryType;
        try {
            summaryType = SummaryType.fromString(type);
        }
        catch (IllegalArgumentException e) {
            String validValues = Arrays.stream(SummaryType.values()).map(SummaryType::getValue).collect(Collectors.joining("', '", "'", "'"));
            return ResponseFactory.serverError().entity((Object)new RestErrors("Unknown type: '" + type + "'. Expected one of: " + validValues)).build();
        }
        int requestedCount = issues.size() + globalIds.size();
        if (requestedCount > 1000) {
            log.info("{} issue summaries requested but only {} will be processed", (Object)requestedCount, (Object)1000);
        }
        List issueKeys = (List)Stream.concat(issues.stream(), globalIds.stream()).limit(1000L).collect(MoreCollectors.toImmutableList());
        return ResponseFactory.ok(this.summaryService.getDetails(summaryType, issueKeys).asJson(this.urlFactory)).build();
    }
}

