/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;

@LicensedOnly
@Consumes(value={"application/json"})
@Path(value="projects/{projectKey}/repos/{repositorySlug}")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class JiraIndexResource {
    private final JiraIndexService indexService;

    @Inject
    public JiraIndexResource(JiraIndexService indexService) {
        this.indexService = indexService;
    }

    @Path(value="/reindex")
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public void reindex(@BeanParam RepositoryResolver repositoryResolver, @QueryParam(value="withCommits") @DefaultValue(value="false") boolean withCommits) {
        this.indexService.reindex(repositoryResolver.getRepository(), withCommits);
    }
}

