/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.ValidationUtils;
import com.atlassian.plugins.rest.api.security.annotation.AdminOnly;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.cloud.config.JiraSitePermissionsService;
import com.atlassian.stash.internal.jira.cloud.config.SimpleJiraSiteConfigRequest;
import com.atlassian.stash.internal.jira.cloud.config.service.JiraSiteConfigService;
import com.atlassian.stash.internal.jira.rest.RestJiraSiteConfig;
import com.atlassian.stash.internal.jira.rest.RestJiraSiteConfigRequest;
import com.atlassian.stash.internal.jira.rest.RestJiraSiteConfigWithPermissions;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.validation.Validator;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Set;

@AdminOnly
@Path(value="/jira-site-config")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@WebSudoRequired
public class JiraSiteConfigurationResource {
    private final JiraSitePermissionsService jiraSitePermissionsService;
    private final JiraSiteConfigService jiraSiteConfigService;
    private final Validator validator;

    @Inject
    public JiraSiteConfigurationResource(JiraSitePermissionsService jiraSitePermissionsService, JiraSiteConfigService jiraSiteConfigService, Validator validator) {
        this.jiraSitePermissionsService = jiraSitePermissionsService;
        this.jiraSiteConfigService = jiraSiteConfigService;
        this.validator = validator;
    }

    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response create(RestJiraSiteConfigRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        SimpleJiraSiteConfigRequest jiraSiteConfigRequest = new SimpleJiraSiteConfigRequest.Builder().clientId(request.getClientId()).clientSecret(request.getClientSecret()).name(request.getName()).url(request.getUrl()).build();
        JiraSiteConfig jiraSiteConfig = this.jiraSiteConfigService.create(jiraSiteConfigRequest);
        return ResponseFactory.ok((Object)((Object)new RestJiraSiteConfig(jiraSiteConfig))).build();
    }

    @DELETE
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response delete(@PathParam(value="id") int id) {
        this.jiraSiteConfigService.delete(id);
        return ResponseFactory.noContent().build();
    }

    @GET
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response get(@PathParam(value="id") int id) {
        JiraSiteConfig jiraSiteConfig = this.jiraSiteConfigService.get(id);
        return ResponseFactory.ok((Object)((Object)new RestJiraSiteConfig(jiraSiteConfig))).build();
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getAll(@BeanParam PageRequestResolver pageRequestResolver) {
        Page<JiraSiteConfig> jiraSiteConfigs = this.jiraSiteConfigService.getAll(pageRequestResolver.getPageRequest());
        Response response = ResponseFactory.ok((Object)new RestPage(jiraSiteConfigs, this::extendWithPermissions)).build();
        return response;
    }

    @GET
    @Path(value="/{id}/refresh-permissions")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response refreshPermissions(@PathParam(value="id") int id) {
        JiraSiteConfig jiraSiteConfig = this.jiraSiteConfigService.get(id);
        Set<JiraCloudOauthPermission> permissionsResponse = this.jiraSitePermissionsService.refreshPermissions(jiraSiteConfig);
        return ResponseFactory.ok((Object)((Object)new RestJiraSiteConfigWithPermissions(jiraSiteConfig, permissionsResponse))).build();
    }

    @PUT
    @Path(value="{id}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response update(@PathParam(value="id") int id, RestJiraSiteConfigRequest request) {
        ValidationUtils.validate((Validator)this.validator, (Object)((Object)request), (Class[])new Class[0]);
        SimpleJiraSiteConfigRequest jiraSiteConfigUpdateRequest = new SimpleJiraSiteConfigRequest.Builder().clientId(request.getClientId()).clientSecret(request.getClientSecret()).name(request.getName()).url(request.getUrl()).build();
        JiraSiteConfig jiraSiteConfig = this.jiraSiteConfigService.update(id, jiraSiteConfigUpdateRequest);
        return ResponseFactory.ok((Object)((Object)new RestJiraSiteConfig(jiraSiteConfig))).build();
    }

    private RestJiraSiteConfig extendWithPermissions(JiraSiteConfig jiraSiteConfig) {
        if (jiraSiteConfig.getConnectionStatus() == ConnectionStatus.CONNECTED) {
            Set<JiraCloudOauthPermission> permissionsResponse = this.jiraSitePermissionsService.getPermissions(jiraSiteConfig);
            return new RestJiraSiteConfigWithPermissions(jiraSiteConfig, permissionsResponse);
        }
        return new RestJiraSiteConfig(jiraSiteConfig);
    }
}

