/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.stash.internal.jira.cloud.config.ConnectionStatus;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.validation.constraints.NotNull;
import java.util.function.Function;

@JsonSerialize
@JsonSurrogate(value=JiraSiteConfig.class)
public class RestJiraSiteConfig
extends RestMapEntity {
    public static final Function<JiraSiteConfig, RestJiraSiteConfig> REST_TRANSFORM = RestJiraSiteConfig::new;
    private static final String ID = "id";
    private static final String CLIENT_ID = "clientId";
    private static final String CLOUD_ID = "cloudId";
    private static final String CONNECTION_STATUS = "connectionStatus";
    private static final String CONNECTION_ERROR_DESCRIPTION = "errorDescription";
    private static final String NAME = "name";
    private static final String URL = "url";

    public RestJiraSiteConfig() {
    }

    public RestJiraSiteConfig(@Nonnull JiraSiteConfig jiraSiteConfig) {
        this(jiraSiteConfig.getId(), jiraSiteConfig.getClientId(), jiraSiteConfig.getCloudId(), jiraSiteConfig.getConnectionStatus(), jiraSiteConfig.getConnectionErrorDescription(), jiraSiteConfig.getName(), jiraSiteConfig.getUrl());
    }

    private RestJiraSiteConfig(int id, String clientId, String cloudId, ConnectionStatus connectionStatus, String errorDescription, String name, String url) {
        this.put(ID, id);
        this.put(CLIENT_ID, clientId);
        this.put(CLOUD_ID, cloudId);
        this.put(CONNECTION_STATUS, (Object)connectionStatus);
        if (connectionStatus != ConnectionStatus.CONNECTED) {
            this.put(CONNECTION_ERROR_DESCRIPTION, errorDescription);
        }
        this.put(NAME, name);
        this.put(URL, url);
    }

    public int getId() {
        return this.getIntProperty(ID);
    }

    @NotNull
    public String getClientId() {
        return this.getStringProperty(CLIENT_ID);
    }

    @NotNull
    public String getCloudId() {
        return this.getStringProperty(CLOUD_ID);
    }

    @NotNull
    public ConnectionStatus getConnectionStatus() {
        return ConnectionStatus.valueOf(CONNECTION_STATUS);
    }

    @NotNull
    public String getName() {
        return this.getStringProperty(NAME);
    }

    @NotNull
    public String getUrl() {
        return this.getStringProperty(URL);
    }
}

