/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.stash.internal.jira.cloud.client.model.JiraCloudOauthPermission;
import com.atlassian.stash.internal.jira.cloud.client.model.PermissionsResponse;
import com.atlassian.stash.internal.jira.cloud.config.JiraSiteConfig;
import com.atlassian.stash.internal.jira.rest.RestJiraSiteConfig;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Set;

@JsonSerialize
public class RestJiraSiteConfigWithPermissions
extends RestJiraSiteConfig {
    private static final String PERMISSIONS = "permissions";

    public RestJiraSiteConfigWithPermissions() {
    }

    public RestJiraSiteConfigWithPermissions(@Nonnull JiraSiteConfig jiraSiteConfig, @Nonnull Set<JiraCloudOauthPermission> permissions) {
        super(jiraSiteConfig);
        this.put(PERMISSIONS, (Object)new RestPermissions(Objects.requireNonNull(permissions, PERMISSIONS)));
    }

    @Nonnull
    public Object getPermissions() {
        return this.get(PERMISSIONS);
    }

    @JsonSerialize
    @JsonSurrogate(value=PermissionsResponse.class)
    private static class RestPermissions
    extends RestMapEntity {
        private static final String BUILDS_PERMISSION = "buildsPermission";
        private static final String DEPLOYMENTS_PERMISSION = "deploymentsPermission";
        private static final String DEV_INFO_PERMISSION = "devInfoPermission";

        public RestPermissions() {
        }

        public RestPermissions(Set<JiraCloudOauthPermission> permissions) {
            this.put(BUILDS_PERMISSION, permissions.contains((Object)JiraCloudOauthPermission.BUILDS));
            this.put(DEPLOYMENTS_PERMISSION, permissions.contains((Object)JiraCloudOauthPermission.DEPLOYMENTS));
            this.put(DEV_INFO_PERMISSION, permissions.contains((Object)JiraCloudOauthPermission.DEV_INFO));
        }

        public boolean hasBuildsPermission() {
            return this.getBoolProperty(BUILDS_PERMISSION, false);
        }

        public boolean hasDeploymentsPermission() {
            return this.getBoolProperty(DEPLOYMENTS_PERMISSION, false);
        }

        public boolean hasDevInfoPermission() {
            return this.getBoolProperty(DEV_INFO_PERMISSION, false);
        }
    }
}

