/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import com.atlassian.stash.internal.jira.rest.RestSmartCommitState;
import com.atlassian.stash.internal.jira.server.config.IssueIndexingConfig;
import jakarta.annotation.Nonnull;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import java.util.Objects;

@AnonymousSiteAccess
@Consumes(value={"application/json"})
@Path(value="/smart-commit")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class SmartCommitResource {
    private IssueIndexingConfig issueIndexingConfig;

    @Inject
    public SmartCommitResource(@Nonnull IssueIndexingConfig issueIndexingConfig) {
        this.issueIndexingConfig = Objects.requireNonNull(issueIndexingConfig);
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getIssueSummary() {
        return Response.ok((Object)new RestSmartCommitState(this.issueIndexingConfig.isSmartCommitsEnabled())).build();
    }
}

