/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.bitbucket.dmz.auth.Anonymous2LORequestVerifier;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.user.SecurityService;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.fusion.schema.summary.SummaryType;
import com.atlassian.linkaggregation.RemoteLinkAggregation;
import com.atlassian.linkaggregation.RemoteLinkAggregator;
import com.atlassian.stash.internal.jira.rest.summary.link.RestRemoteLinkAggregationSummary;
import com.atlassian.stash.internal.jira.summary.IssueSummary;
import com.atlassian.stash.internal.jira.summary.SummaryService;
import jakarta.annotation.Nonnull;
import java.util.Map;
import java.util.stream.Collectors;

public class SummaryLinkAggregator
implements RemoteLinkAggregator {
    private final Anonymous2LORequestVerifier anonymous2LORequestVerifier;
    private final SecurityService securityService;
    private final SummaryService summaryService;

    public SummaryLinkAggregator(Anonymous2LORequestVerifier anonymous2LORequestVerifier, SecurityService securityService, SummaryService summaryService) {
        this.anonymous2LORequestVerifier = anonymous2LORequestVerifier;
        this.securityService = securityService;
        this.summaryService = summaryService;
    }

    @Nonnull
    public Map<String, Iterable<RemoteLinkAggregation>> aggregateForGlobalIds(@Nonnull Iterable<String> globalIds) {
        return this.anonymous2LORequestVerifier.isValid("REPO_READ") ? (Map)this.securityService.withPermission(Permission.REPO_READ, "retrieve summary information for applink").call(() -> this.getSummaries(globalIds)) : this.getSummaries(globalIds);
    }

    private static RemoteLinkAggregation toRemoteLinkAggregation(IssueSummary summary) {
        return new RestRemoteLinkAggregationSummary(new SummaryType(summary.getType().getValue()), summary.getObjects());
    }

    private Map<String, Iterable<RemoteLinkAggregation>> getSummaries(Iterable<String> issueKeys) {
        return this.summaryService.getSummaries(issueKeys).stream().collect(Collectors.groupingBy(IssueSummary::getKey, Collectors.mapping(SummaryLinkAggregator::toRemoteLinkAggregation, Collectors.collectingAndThen(MoreCollectors.toImmutableList(), list -> list))));
    }
}

