/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.rest.v2.api.annotation.EscalateAnonymous2LO;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.fusion.schema.pull.PullChangesResponse;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import com.atlassian.stash.internal.jira.index.IssueUpdates;
import com.atlassian.stash.internal.jira.index.JiraIndexService;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DefaultValue;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

@UnrestrictedAccess
@Consumes(value={"application/json"})
@Path(value="/updated-issues")
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
public class UpdatedIssuesResource {
    private final I18nService i18nService;
    private final JiraIndexService indexService;

    @Inject
    public UpdatedIssuesResource(I18nService i18nService, JiraIndexService indexService) {
        this.i18nService = i18nService;
        this.indexService = indexService;
    }

    @EscalateAnonymous2LO(value={Permission.REPO_READ})
    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getChanges(@QueryParam(value="sequenceNo") @DefaultValue(value="") String sequenceNoStr, @QueryParam(value="maxResults") @DefaultValue(value="1000") String maxResultsStr) {
        int maxResults = this.parseMaxResults(maxResultsStr);
        if (StringUtils.isEmpty((CharSequence)sequenceNoStr)) {
            return UpdatedIssuesResource.makeResponse(Long.toString(System.currentTimeMillis()), Collections.emptySet(), false);
        }
        IssueUpdates updates = this.indexService.findUpdatedIssues(sequenceNoStr, maxResults);
        return UpdatedIssuesResource.makeResponse(updates.getLastRecordSequenceNumber(), updates.getIssues(), updates.getMoreAvailable());
    }

    private static Response makeResponse(String newSequenceNumber, Set<String> issueKeys, boolean moreAvailable) {
        return ResponseFactory.ok((Object)new PullChangesResponse(newSequenceNumber, moreAvailable, issueKeys)).build();
    }

    private int parseMaxResults(String str) {
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException ignored) {
            throw new ArgumentValidationException(this.i18nService.createKeyedMessage("bitbucket.jira-development-integration.index.service.request.limit.invalid", new Object[]{str}));
        }
    }
}

