/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest.summary;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.objects.BranchesObject;
import com.atlassian.stash.internal.jira.index.IndexResult;
import com.atlassian.stash.internal.jira.rest.summary.RestSummaryObject;
import com.atlassian.stash.internal.jira.util.RepositoryHelper;
import com.google.common.annotations.VisibleForTesting;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class RestResultSummary
implements RestSummaryObject {
    private final Function<String, String> unqualifyBranch;
    private final List<IndexResult> indexResults;

    public RestResultSummary(Repository repository, List<IndexResult> indexResults) {
        this.unqualifyBranch = RepositoryHelper.unqualifyFor(repository);
        this.indexResults = indexResults;
    }

    @Override
    @Nonnull
    public SummaryObject asJson() {
        return ((BranchesObject.Builder)new BranchesObject.Builder(this.getRefNames()).lastUpdated(this.getLastUpdated())).build();
    }

    @VisibleForTesting
    public List<IndexResult> getIndexResults() {
        return this.indexResults;
    }

    @Nullable
    private Date getLastUpdated() {
        return this.indexResults.stream().map(IndexResult::getLastUpdated).filter(Objects::nonNull).sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().orElse(null);
    }

    @Nonnull
    private List<String> getRefNames() {
        return (List)this.indexResults.stream().map(IndexResult::getRefId).map(this.unqualifyBranch).collect(MoreCollectors.toImmutableList());
    }
}

