/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest.summary.branch;

import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.fusion.schema.detail.branch.Branch;
import com.atlassian.stash.internal.jira.rest.summary.RestDetailObject;
import com.atlassian.stash.internal.jira.rest.summary.RestRepositoryHelper;
import com.atlassian.stash.internal.jira.util.RepositoryHelper;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import jakarta.annotation.Nonnull;
import java.util.function.Function;

public class RestBranchDetail
implements RestDetailObject<Branch> {
    private final boolean canWrite;
    private final Function<String, String> unqualifyBranch;
    private final Repository repository;
    private final String refId;

    public RestBranchDetail(Repository repository, String refId, boolean canWrite) {
        this.canWrite = canWrite;
        this.repository = repository;
        this.unqualifyBranch = RepositoryHelper.unqualifyFor(repository);
        this.refId = refId;
    }

    @Override
    @Nonnull
    public Branch asJson(@Nonnull UrlFactory urlFactory) {
        String url = urlFactory.ref(this.repository, this.refId);
        String createPullRequestUrl = this.canWrite ? urlFactory.createPullRequest(this.repository, this.refId) : null;
        return ((Branch.Builder)new Branch.Builder(this.unqualifyBranch.apply(this.refId), url).repository(RestRepositoryHelper.asJson(this.repository, urlFactory)).createPullRequestUrl(createPullRequestUrl)).build();
    }

    public String getRefId() {
        return this.refId;
    }

    public Repository getRepository() {
        return this.repository;
    }

    public boolean isCanWrite() {
        return this.canWrite;
    }
}

