/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest.summary.commit;

import com.atlassian.bitbucket.commit.Changeset;
import com.atlassian.bitbucket.content.Change;
import com.atlassian.bitbucket.content.ChangeType;
import com.atlassian.bitbucket.user.Person;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.fusion.schema.detail.commit.Commit;
import com.atlassian.fusion.schema.detail.commit.Committer;
import com.atlassian.fusion.schema.detail.commit.File;
import com.atlassian.fusion.schema.detail.commit.Repository;
import com.atlassian.stash.internal.jira.rest.summary.RestDetailObject;
import com.atlassian.stash.internal.jira.rest.summary.RestRepositoryHelper;
import com.atlassian.stash.internal.jira.util.UrlFactory;
import jakarta.annotation.Nonnull;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class RestCommitDetail
implements RestDetailObject<Repository> {
    private final com.atlassian.bitbucket.repository.Repository repository;
    private final List<Changeset> changesets;

    public RestCommitDetail(@Nonnull com.atlassian.bitbucket.repository.Repository repository, @Nonnull List<Changeset> changesets) {
        this.repository = Objects.requireNonNull(repository, "repository");
        this.changesets = Objects.requireNonNull(changesets, "changesets");
    }

    @Override
    @Nonnull
    public Repository asJson(@Nonnull UrlFactory urlFactory) {
        return ((Repository.Builder)((Repository.Builder)((Repository.Builder)((Repository.Builder)new Repository.Builder(this.repository.getName()).url(urlFactory.repository(this.repository))).avatar(urlFactory.projectAvatar(this.repository.getProject()))).avatarDescription(this.repository.getProject().getName())).parent(RestRepositoryHelper.asJson(this.repository.getOrigin(), urlFactory))).addCommits(RestCommitDetail.toCommits(this.changesets, urlFactory)).build();
    }

    @Nonnull
    public List<Changeset> getChangesets() {
        return this.changesets;
    }

    @Nonnull
    public com.atlassian.bitbucket.repository.Repository getRepository() {
        return this.repository;
    }

    private static Committer toCommitter(Person author, UrlFactory urlFactory) {
        return ((Committer.Builder)new Committer.Builder(author.getName()).avatar(urlFactory.userAvatar(author))).build();
    }

    private static List<Commit> toCommits(List<Changeset> changesets, UrlFactory urlFactory) {
        return (List)changesets.stream().map(changeset -> {
            com.atlassian.bitbucket.commit.Commit commit = changeset.getToCommit();
            int changeSize = changeset.getChanges() == null ? 0 : changeset.getChanges().getSize();
            return ((Commit.Builder)((Commit.Builder)((Commit.Builder)new Commit.Builder(commit.getId()).displayId(commit.getDisplayId())).author(RestCommitDetail.toCommitter(commit.getAuthor(), urlFactory)).authorTimestamp(commit.getAuthorTimestamp())).fileCount(changeSize).addFiles(RestCommitDetail.toFiles((Page<Change>)changeset.getChanges(), change -> urlFactory.fileAtCommit(commit, change.getPath()))).merge(commit.getParents().size() > 1).message(commit.getMessage()).url(urlFactory.commit(commit))).build();
        }).collect(MoreCollectors.toImmutableList());
    }

    private static List<File> toFiles(Page<Change> changes, Function<Change, String> toFileUrl) {
        return changes == null ? Collections.emptyList() : (List)changes.stream().map(change -> new File.Builder(change.getPath().toString(), (String)toFileUrl.apply((Change)change), RestCommitDetail.toFileChangeType(change.getType())).build()).limit(5L).collect(MoreCollectors.toImmutableList());
    }

    private static File.ChangeType toFileChangeType(ChangeType changeType) {
        switch (changeType) {
            case ADD: {
                return File.ChangeType.ADDED;
            }
            case COPY: {
                return File.ChangeType.COPIED;
            }
            case DELETE: {
                return File.ChangeType.DELETED;
            }
            case MODIFY: {
                return File.ChangeType.MODIFIED;
            }
            case MOVE: {
                return File.ChangeType.MOVED;
            }
        }
        return File.ChangeType.UNKNOWN;
    }
}

