/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.stash.internal.jira.rest.summary.commit;

import com.atlassian.bitbucket.idx.IndexedCommit;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.atlassian.fusion.schema.summary.SummaryObject;
import com.atlassian.fusion.schema.summary.objects.CommitsObject;
import com.atlassian.stash.internal.jira.rest.summary.RestSummaryObject;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class RestCommitSummary
implements RestSummaryObject {
    private final Repository repository;
    private final List<IndexedCommit> indexedCommits;

    public RestCommitSummary(Repository repository, List<IndexedCommit> indexedCommits) {
        this.repository = repository;
        this.indexedCommits = indexedCommits;
    }

    @Override
    @Nonnull
    public SummaryObject asJson() {
        return ((CommitsObject.Builder)new CommitsObject.Builder(this.getCommitIds()).lastUpdated(this.getLastUpdated())).type(this.repository.getScmId()).build();
    }

    @Nullable
    private Date getLastUpdated() {
        return this.indexedCommits.stream().map(IndexedCommit::getAuthorTimestamp).filter(Objects::nonNull).sorted(Comparator.comparing(Date::getTime).reversed()).findFirst().orElse(null);
    }

    @Nonnull
    private List<String> getCommitIds() {
        return (List)this.indexedCommits.stream().map(IndexedCommit::getId).collect(MoreCollectors.toImmutableList());
    }
}

